package com.bcxin.obpm.service.impl;

import com.alibaba.fastjson.JSON;
import com.bcxin.auth.common.constant.Constants;
import com.bcxin.auth.common.utils.IdWorker;
import com.bcxin.auth.common.utils.PDFUtils;
import com.bcxin.auth.common.utils.StringUtils;
import com.bcxin.auth.common.vo.CommonClass;
import com.bcxin.auth.system.domain.CertificatePaths;
import com.bcxin.auth.system.domain.HonorCertificate;
import com.bcxin.auth.system.domain.SecurityService;
import com.bcxin.auth.system.service.ISysConfigService;
import com.bcxin.auth.system.domain.ComCerDto;
import com.bcxin.auth.system.util.ConfigUtil;
import com.bcxin.auth.system.util.FileUtil;
import com.bcxin.obpm.dto.PdfChangeDTO;
import com.bcxin.obpm.mapper.ProjectChangeMapper;
import com.bcxin.obpm.service.CreatePDFService;
import com.bcxin.obpm.service.StampService;
import com.bcxin.obpm.util.DateUtil;
import com.github.pagehelper.util.StringUtil;
import com.itextpdf.text.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.*;
import java.util.stream.IntStream;

@Service
public class CreatePDFServiceImpl implements CreatePDFService {

    protected Logger logger = LoggerFactory.getLogger(CreatePDFServiceImpl.class);

    @Autowired
    private ISysConfigService configService;

    @Value("${bcxin.profile}")
    private String baseFolder;

    @Value("${bcxin.storage.root}")
    String rootPath;
    @Resource
    private ConfigUtil configUtil;

//    @Resource
//    private ConfigUtil configUtil;

    @Autowired
    IdWorker idWorker;

    @Autowired
    private StampService stampService;

    @Override
    public String createPDF(ComCerDto comCerDto, String businesstype) throws Exception {
        String path = "";
        String templatePath = CreatePDFServiceImpl.class.getResource("/").toString();
        String ConfigValue = configService.selectConfigByKey(Constants.CURRENT_PROVINCE);
        //公司证书正本
        String companyCertificate1_Path = templatePath + "pdfTemplate/CompanyCertificate-1-6.pdf";
        //公司证书副本
        String companyCertificate2_Path = templatePath + "pdfTemplate/CompanyCertificate-2-6.pdf";
        Date now = new Date();
        String companyCertificate1FileName = now.getTime() + "_companyCertificate1.pdf";
        String companyCertificate2FileName = now.getTime() + "_companyCertificate2.pdf";

        String dirDate = DateUtil.systemDate.format(now);
        String filePath = "pdf/" + dirDate + "/";
        String pdfPath = baseFolder + filePath;
        String companyCertificate2PathChange = pdfPath +"change_"+ companyCertificate2FileName;
        File pdfFile = new File(pdfPath);
        if (!pdfFile.exists()) {
            pdfFile.mkdirs();
        }

        String companyCertificate1Path = pdfPath + companyCertificate1FileName;
        String companyCertificate2Path = pdfPath + companyCertificate2FileName;
        //保安服务公司许可申请
        if ("001".equals(businesstype)) {
            //获取数据
            ComCerDto printData = getcompanyCertificateData(comCerDto);

            if (null != printData) {

                if (StringUtil.isEmpty(printData.getGsdz_2())) {
                    //公司证书正本
                    companyCertificate1_Path = templatePath + "pdfTemplate/CompanyCertificate-1-6_single.pdf";
                    //公司证书副本
                    companyCertificate2_Path = templatePath + "pdfTemplate/CompanyCertificate-2-6_single.pdf";
                }
                if (StringUtil.isNotEmpty(printData.getGsdz_3())) {
                    //公司证书副本
                    companyCertificate2_Path = templatePath + "pdfTemplate/CompanyCertificate-2-6-3.pdf";
                }

                if (printData.getGsmc().length() > 15) {
                    //公司证书副本
                    companyCertificate2_Path = templatePath + "pdfTemplate/CompanyCertificate-2-6_c.pdf";
                }

                /**
                 * 生成
                 * */
                if (comCerDto.getZf().equals("f")) {
                    if (printData.getPdfChangeDTOList()!=null) {
                        ArrayList<CommonClass> commonClassArrayList = new ArrayList<CommonClass>();
                        printData.getPdfChangeDTOList().forEach(pdfChangeDTO -> {
                            CommonClass commonClass = parsePdfClass(pdfChangeDTO);
                            commonClassArrayList.add(commonClass);
                        });
                        PDFUtils.addPDFChange(companyCertificate2_Path, companyCertificate2PathChange, commonClassArrayList);
                        PDFUtils.createPDFForTemplate(companyCertificate2PathChange, companyCertificate2Path, printData);
                    }else{
                        PDFUtils.createPDFForTemplate(companyCertificate2_Path, companyCertificate2Path, printData);
                    }

                    //陕西需要盖章
                    if (null != ConfigValue && "610000".equals(ConfigValue)) {
                        stampService.addStamp(companyCertificate2Path, "2");
                    }
                    path = baseFolder+filePath + companyCertificate2FileName;
                } else {
                    PDFUtils.createPDFForTemplate(companyCertificate1_Path, companyCertificate1Path, printData);

                    if (null != ConfigValue && "610000".equals(ConfigValue)) {
                        stampService.addStamp(companyCertificate1Path, "1");
                    }
                    path = baseFolder+filePath + companyCertificate1FileName;
                }
            }
        }
        return path;
    }

    @Override
    public Map<String,String> createSecurityServicePDF(SecurityService securityService) throws Exception {
        String templatePath = CreatePDFServiceImpl.class.getResource("/").toString();
        //公司证书正本
        String companyCertificate1_Path = templatePath + "pdfTemplate/bj_companyCertificate-z.pdf";
        //公司证书副本
        String companyCertificate2_Path = templatePath + "pdfTemplate/bj_companyCertificate-f.pdf";
        Date now = new Date();
        String companyCertificateFileName_z = securityService.getGsmc()+"正本"+now.getTime() + ".pdf";
        String companyCertificateFileName_f = securityService.getGsmc()+"副本"+now.getTime() + ".pdf";
        String dirDate = DateUtil.systemDate.format(now);
        String filePath = "pdf/" + dirDate + "/";
        String pdfPath = rootPath + filePath;
        File pdfFile = new File(pdfPath);
        if (!pdfFile.exists()) {
            pdfFile.mkdirs();
        }
        String companyCertificate1Path = pdfPath + companyCertificateFileName_z;
        String companyCertificate2Path = pdfPath + companyCertificateFileName_f;
        //获取数据
        SecurityService printData = parseCompanyCertificateData(securityService);
        HashMap<String, String> urlPath = new HashMap<>();
        //生成正本
        PDFUtils.createPDF(companyCertificate1_Path, companyCertificate1Path, printData);
        urlPath.put("z","/uploads/"+filePath + companyCertificateFileName_z);
        //生成副本
        PDFUtils.createPDF(companyCertificate2_Path, companyCertificate2Path, printData);
        urlPath.put("f","/uploads/"+filePath + companyCertificateFileName_f);
        return urlPath;
    }

    @Override
    public List<HonorCertificate> createHonorCertificatePDF(List<HonorCertificate> honorCertificates) throws Exception {
        if (honorCertificates.size() == 0){
            return honorCertificates;
        }else {
            String templatePath = CreatePDFServiceImpl.class.getResource("/").toString();
            String honorCertificate_Path = templatePath + "pdfTemplate/honorCertificate.pdf";
            Date now = new Date();
            String dirDate = DateUtil.systemDate.format(now);
            String filePath = "pdf/" + dirDate + "/";
            //String pdfPath = rootPath + filePath;
            String pdfPath = baseFolder + filePath;
            File pdfFile = new File(pdfPath);
            if (!pdfFile.exists()) {
                pdfFile.mkdirs();
            }
            honorCertificates.forEach(honorCertificate -> {
                String honorCertificateFileName = honorCertificate.getName() +  now.getTime() + ".pdf";
                String honorCertificatePath = pdfPath + honorCertificateFileName;
                try {
                    PDFUtils.createPDF(honorCertificate_Path, honorCertificatePath, honorCertificate);
                    honorCertificate.setPdfUrl("/manage/cer/getResource?path="+honorCertificatePath);
                } catch (IOException e) {
                    e.printStackTrace();
                } catch (DocumentException e) {
                    e.printStackTrace();
                }
            });
            return honorCertificates;
        }
    }

    ComCerDto getcompanyCertificateData(ComCerDto comCerDto) {
        //正本数据
        ComCerDto printData = new ComCerDto();
        //注册资本
        if (StringUtil.isNotEmpty(comCerDto.getZczb())) {
            printData.setZczb(digitUppercase(Double.parseDouble(comCerDto.getZczb())));
        }
        //批准文号
        if (StringUtil.isNotEmpty(comCerDto.getPzwh())) {
            printData.setPzwh(comCerDto.getPzwh().replace("【", "[").replace("】", "]"));
        }
        //公司名称
        if (StringUtil.isNotEmpty(comCerDto.getGsmc())) {
            printData.setGsmc(comCerDto.getGsmc());
        }
        //法人
        if (StringUtil.isNotEmpty(comCerDto.getFrmc())) {
            printData.setFrmc(comCerDto.getFrmc());
        }
        //证书号
        try {
            printData.setXkzh(comCerDto.getXkzh().substring(0, comCerDto.getXkzh().indexOf("2")) + " " + comCerDto.getXkzh().substring(comCerDto.getXkzh().indexOf("2")));
        } catch (Exception e) {
            printData.setXkzh(comCerDto.getXkzh().substring(0, comCerDto.getXkzh().indexOf("服") + 1) + " " + comCerDto.getXkzh().substring(comCerDto.getXkzh().indexOf("服") + 1));
        }
        //证书结尾加上号
        printData.setXkzh(printData.getXkzh() != null && !printData.getXkzh().endsWith("号") ? printData.getXkzh() + "号" : printData.getXkzh());
        //发证日期
        if (null != comCerDto.getFzrq()) {
            printData.setFzrqn(comCerDto.getFzrq().substring(0, 4));
            printData.setFzrqy(comCerDto.getFzrq().substring(5, 7));
            printData.setFzrqr(comCerDto.getFzrq().substring(8, 10));
        }
        //服务范围
        if (null != comCerDto.getManagement()) {
            String fwfw = comCerDto.getManagement();
            if (null != fwfw && fwfw.length() > 19) {
                printData.setManagement(fwfw.substring(0, 19));
                printData.setManagement2(fwfw.substring(19));
            } else {
                printData.setManagement(fwfw);
            }

            //副本
            if(null!=fwfw && fwfw.length()>19){
                printData.setManagement_1(fwfw.substring(0,19));
                printData.setManagement_2(fwfw.substring(19));
            }else{
                printData.setManagement_1(fwfw);
            }
        }
        //公司地址(副本)
        if (null != comCerDto.getGsdz() && comCerDto.getGsdz().length() > 16) {
            printData.setGsdz_1(comCerDto.getGsdz().substring(0, 16));
            printData.setGsdz_2(comCerDto.getGsdz().substring(16));
            if (comCerDto.getGsdz().length() > 34) {
                printData.setGsdz_2(comCerDto.getGsdz().substring(16, 32));
                printData.setGsdz_3(comCerDto.getGsdz().substring(32));
            }
        } else {
            printData.setGsdz_1(comCerDto.getGsdz());
        }
        //公司地址(正本)
        if (null != comCerDto.getGsdz() && comCerDto.getGsdz().length() > 20) {
            printData.setGsdz(comCerDto.getGsdz().substring(0, 20));
            printData.setGsdz2(comCerDto.getGsdz().substring(20));
        } else {
            printData.setGsdz(comCerDto.getGsdz());
        }
        /*List<PdfChangeDTO> pdfChangeDTOList = new ArrayList<>();
        PdfChangeDTO pdfChangeDTO;
        List<ProjectChange> projectChangeList3 = projectChangeMapper.findCCmoneyChangeK(companyCertificate.getCertificateNumber());
        List<ProjectChange> projectChangeList1 = projectChangeMapper.findLegalChangeK(companyCertificate.getCertificateNumber());
        List<ProjectChange> projectChangeList4 = projectChangeMapper.findScopeAddressChangeK(companyCertificate.getCertificateNumber());
        List<ProjectChange> projectChangeList2 = projectChangeMapper.findScopNameChangeS(companyCertificate.getCertificateNumber());
        List<ProjectChange> projectChangeList5 = projectChangeMapper.findScopeBusinessK(companyCertificate.getCertificateNumber());

        if (null != projectChangeList1 && projectChangeList1.size() > 0) {
            for (ProjectChange p : projectChangeList1) {
                pdfChangeDTO = new PdfChangeDTO();
                pdfChangeDTO.setProject(p.getProjectname());
                pdfChangeDTO.setAfterChange(p.getProjectcontent());
                pdfChangeDTO.setTime(p.getProjecttime());
                pdfChangeDTOList.add(pdfChangeDTO);

            }
        }
        if (null != projectChangeList2 && projectChangeList2.size() > 0) {
            for (ProjectChange p : projectChangeList2) {
                pdfChangeDTO = new PdfChangeDTO();
                pdfChangeDTO.setProject(p.getProjectname());
                pdfChangeDTO.setAfterChange(p.getProjectcontent());
                pdfChangeDTO.setTime(p.getProjecttime());
                pdfChangeDTOList.add(pdfChangeDTO);

            }
        }
        if (null != projectChangeList3 && projectChangeList3.size() > 0) {
            for (ProjectChange p : projectChangeList3) {
                pdfChangeDTO = new PdfChangeDTO();
                pdfChangeDTO.setProject(p.getProjectname());
                pdfChangeDTO.setAfterChange(p.getProjectcontent());
                pdfChangeDTO.setTime(p.getProjecttime());
                pdfChangeDTOList.add(pdfChangeDTO);

            }
        }
        if (null != projectChangeList4 && projectChangeList4.size() > 0) {
            for (ProjectChange p : projectChangeList4) {
                pdfChangeDTO = new PdfChangeDTO();
                pdfChangeDTO.setProject(p.getProjectname());
                pdfChangeDTO.setAfterChange(p.getProjectcontent());
                pdfChangeDTO.setTime(p.getProjecttime());
                pdfChangeDTOList.add(pdfChangeDTO);

            }
        }
        if (null != projectChangeList5 && projectChangeList5.size() > 0) {
            for (ProjectChange p : projectChangeList5) {
                pdfChangeDTO = new PdfChangeDTO();
                pdfChangeDTO.setProject(p.getProjectname());
                pdfChangeDTO.setAfterChange(p.getProjectcontent());
                pdfChangeDTO.setTime(p.getProjecttime());
                pdfChangeDTOList.add(pdfChangeDTO);

            }
        }*/
        if (null != comCerDto.getPdfChangeDTOList() && comCerDto.getPdfChangeDTOList().size() > 0) {
            printData.setPdfChangeDTOList(comCerDto.getPdfChangeDTOList());
        }
        return printData;
    }

    //用于北京许可证pdf生成转换数据封装
    private SecurityService parseCompanyCertificateData(SecurityService securityService) {



        //公司地址(正本)
        if (null != securityService.getGsdz() && securityService.getGsdz().length() > 20) {
//            securityService.setGsdz1(securityService.getGsdz().substring(0, 20));
//            securityService.setGsdz2(securityService.getGsdz().substring(20));
            securityService.setGsdz1(securityService.getGsdz());
        } else {
            securityService.setGsdz1(securityService.getGsdz());
        }


        //公司地址(副本)
        if (null != securityService.getGsdz() && securityService.getGsdz().length() > 16) {
//            securityService.setGsdz_1(securityService.getGsdz().substring(0, 16));
//            securityService.setGsdz_2(securityService.getGsdz().substring(16));
            securityService.setGsdz_1(securityService.getGsdz());
        } else {
            securityService.setGsdz_1(securityService.getGsdz());
        }

        //发证日期
        if (null != securityService.getFzrq()) {
            securityService.setFzrqn(securityService.getFzrq().substring(0, 4));
            securityService.setFzrqy(securityService.getFzrq().substring(5, 7));
            securityService.setFzrqr(securityService.getFzrq().substring(8, 10));
        }

        //经营范围
        if (null != securityService.getManagement()) {
            securityService.setManagement(formatManagement(securityService.getManagement()));
        }


        return securityService;
    }

    /**
     * 数字金额大写转换，思想先写个完整的然后将如零拾替换成零 要用到正则表达式
     */
    public static String digitUppercase(double v) {
        //默认传的是万元为单位 转成元
        v = v * 10000;

        String UNIT = "万仟佰拾亿仟佰拾万仟佰拾元角分";
        String DIGIT = "零壹贰叁肆伍陆柒捌玖";
        double MAX_VALUE = 9999999999999.99D;

        if (v < 0 || v > MAX_VALUE) {
            return "参数非法!";
        }
        long l = Math.round(v * 100);
        if (l == 0) {
            return "零元";
        }
        String strValue = l + "";
        // i用来控制数
        int i = 0;
        // j用来控制单位
        int j = UNIT.length() - strValue.length();
        String rs = "";
        boolean isZero = false;
        for (; i < strValue.length(); i++, j++) {
            char ch = strValue.charAt(i);
            if (ch == '0') {
                isZero = true;
                if (UNIT.charAt(j) == '亿' || UNIT.charAt(j) == '万' || UNIT.charAt(j) == '元') {
                    rs = rs + UNIT.charAt(j);
                    isZero = false;
                }
            } else {
                if (isZero) {
                    rs = rs + "零";
                    isZero = false;
                }
                rs = rs + DIGIT.charAt(ch - '0') + UNIT.charAt(j);
            }
        }
        rs = rs.replaceAll("亿万", "亿");
        return rs;
    }


    String formatManagement(String fwfw) {
        if (StringUtil.isEmpty(fwfw)) {
            return "";
        }
        StringBuffer management = new StringBuffer();
        //服务范围打印顺序  /*01门卫  02巡逻 03守护  05随身护卫 06安全检查 08安全风险评估 09安全技术防范  */
        String[] orders = new String[]{"01", "02", "03", "04", "05", "06", "07", "09", "08"};
        String[] ss = fwfw.split(";");
        for (int j = 0; j < orders.length; j++) {
            for (int i = 0; i < ss.length; i++) {
                if (orders[j].equals(ss[i])) {
                    if ("01".equals(ss[i])) {
                        management.append("门卫、");
                    } else if ("02".equals(ss[i])) {
                        management.append("巡逻、");
                    } else if ("03".equals(ss[i])) {
                        management.append("守护、");
                    } else if ("05".equals(ss[i])) {
                        management.append("随身护卫、");
                    } else if ("04".equals(ss[i])) {
                        // 判断是否为北京
                        if ("11".equals(configUtil.getCurrentNative())) {
                            management.append("武装押运、"); // 北京
                        } else {
                            management.append("押运、"); // 陕西或其他地区
                        }
                    } else if ("07".equals(ss[i])) {
                        if (!"11".equals(configUtil.getCurrentNative())) {
                            management.append("区域秩序维护、");
                        }
                    } else if ("06".equals(ss[i])) {
                        management.append("安全检查、");
                    } else if ("08".equals(ss[i])) {
                        management.append("安全风险评估、");
                    } else if ("09".equals(ss[i])) {
                        management.append("安全技术防范、");
                    } else if ("10".equals(ss[i])) {
                        if (!"11".equals(configUtil.getCurrentNative())) {
                            management.append("其他");                        }
//                        management.append("其他");
                    }
                }

            }
        }
        return management.toString().substring(0, management.toString().length() - 1);

    }

    public static CommonClass parsePdfClass(PdfChangeDTO pdfChangeDTO) {
        CommonClass commonClass = new CommonClass();
        commonClass.setField1(pdfChangeDTO.getProject());
        commonClass.setField2(pdfChangeDTO.getAfterChange());
        commonClass.setField3(pdfChangeDTO.getTime());
        return commonClass;
    }

    @Override
    public List<String> mergePdfServer(CertificatePaths certificatePaths) throws Exception {

        logger.info("mergePdfServer certificatePaths: {}", JSON.toJSONString(certificatePaths));
        String[] paths = certificatePaths.getPaths();
        if (paths == null || paths.length==0){
            throw new FileNotFoundException("Font paths not found: " + JSON.toJSONString(certificatePaths));
        }else {
            List<String> result = new ArrayList<>();
            List<String> list = Arrays.asList(paths); // 将数组转换为List以方便使用stream操作
            IntStream.range(0, list.size())
                    .filter(i -> i % 2 == 0) // 仅选择偶数索引的元素（即第一个元素）
                    .forEach(i -> {
                        //生成一个空文件的服务器地址
                        String outpdf = tempDownload("");
                        logger.info("mergePdfServer outpdf: {}", outpdf);
                        if (i + 1 < list.size()) { // 检查是否有下一个元素以形成pair
                            String inpdf1 = list.get(i);if(!inpdf1.contains(rootPath)){inpdf1 = rootPath + inpdf1;}
                            String inpdf2 = list.get(i + 1);if(!inpdf2.contains(rootPath)){inpdf2 = rootPath + inpdf2;}
                            float bl1 = 1.05f;
                            float bl2 = 1.05f;
                            if(!inpdf1.contains("C6101")){
                                bl1 = 1f;
                            }
                            if(!inpdf2.contains("C6101")){
                                bl2 = 1f;
                            }
                            //暂存
                            inpdf1 = tempDownload(inpdf1);
                            inpdf2 = tempDownload(inpdf2);
                            logger.info("mergePdfServer inpdf1: {}", inpdf1);
                            logger.info("mergePdfServer inpdf2: {}", inpdf2);
                            try {
                                PDFUtils.mergePdf1(inpdf1, inpdf2, outpdf,bl1,bl2);
                            } catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                            result.add(configUtil.getLocalHostURL() + "/manage/cer/viewResource?path="+outpdf);
                        } else { // 单独处理最后一个元素（如果存在）
                            String inpdf1 = list.get(i);if(!inpdf1.contains(rootPath)){inpdf1 = rootPath + inpdf1;}
                            float bl1 = 1.05f;
                            if(!inpdf1.contains("C6101")){
                                bl1 = 1f;
                            }
                            //暂存
                            inpdf1 = tempDownload(inpdf1);
                            logger.info("mergePdfServer inpdf1: {}", inpdf1);
                            try {
                                PDFUtils.mergePdf1(inpdf1, "", outpdf,bl1,0);
                            } catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                            result.add(configUtil.getLocalHostURL() + "/manage/cer/viewResource?path="+outpdf);
                        }
                    });
            return result;
        }
    }

    /**
     * <b> 如果有传远程地址对远程地址做暂存本地返回本地存储地址，如果没url就只生成本地地址 </b>
     * @author ZXF
     * @create 2025/03/12 0012 17:28
     * @version
     * @注意事项 </b>
     */
    private String tempDownload(String url){
        Date now = new Date();
        String dirDate = DateUtil.systemDate.format(now);
        String filePath = "temp/" + dirDate + "/";
        String pdfPath = baseFolder + filePath + idWorker.nextId() + ".pdf";
        if(StringUtils.isNotEmpty(url)){
            try {
                FileUtil.downloadFile1(url,pdfPath);
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return pdfPath;
    }

    public static void main(String[] args) throws Exception {
        String pdfPath = "https://bcxinsaasprod.baibaodun.cn:443/upload%2Fcommon%2F2025-06-10%2F50a1a054-5602-4ea8-b306-92e099e11a07.pdf"; // PDF文件路径
//        String pdfPath = "http://v5qy.baibaodun.cn/obpm/uploads/pdf/dianziqianzhang/shanxi/2025-03-17/C610700queueId_3666.pdf"; // PDF文件路径
        try {
//            FileUtil.downloadFile1(pdfPath,"D:\\ase\\temp\\2025-06-10\\123.pdf");
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        String inpdf1="C:\\Users\\Administrator\\Downloads\\C610100queueId_14423.pdf";
        String inpdf2="C:\\Users\\Administrator\\Downloads\\C610700queueId_3806.pdf";
        String outpdf="D:\\ase\\temp\\2025-06-10\\20250312171107.pdf";
        float bl1 = 1.05f;
        float bl2 = 1.05f;
        if(!inpdf1.contains("C6101")){
            bl1 = 1f;
        }
        if(!inpdf2.contains("C6101")){
            bl2 = 1f;
        }
        PDFUtils.mergePdf1(inpdf1, inpdf2, outpdf,bl1,bl2);
    }

}
