package com.bcxin.obpm.ministerial;


import com.bcxin.obpm.annotation.MinisterialAttr;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

/**
 * 民族转换
 * @author linqinglin
 * @date 2021/03/06 0006 13:20
 */
@Component
public class NationMinDataFormatStrategy implements MinDataFormatStrategy {
    @Override
    public String format(Field columnField, Object data) {

        if(data == null){
            MinisterialAttr resource = columnField.getAnnotation(MinisterialAttr.class);
            return resource.defaultValue();
        }

        Map<String,String> nationMap = new HashMap<>();
        nationMap.put("汉族","01");
        nationMap.put("蒙古族","02");
        nationMap.put("回族","03");
        nationMap.put("藏族","04");
        nationMap.put("维吾尔族","05");
        nationMap.put("苗族","06");
        nationMap.put("彝族","07");
        nationMap.put("壮族","08");
        nationMap.put("布依族","09");
        nationMap.put("朝鲜族","10");
        nationMap.put("满族","11");
        nationMap.put("侗族","12");
        nationMap.put("瑶族","13");
        nationMap.put("白族","14");
        nationMap.put("土家族","15");
        nationMap.put("哈尼族","16");
        nationMap.put("哈萨克族","17");
        nationMap.put("傣族","18");
        nationMap.put("黎族","19");
        nationMap.put("傈僳族","20");
        nationMap.put("佤族","21");
        nationMap.put("畲族","22");
        nationMap.put("高山族","23");
        nationMap.put("拉祜族","24");
        nationMap.put("水族","25");
        nationMap.put("东乡族","26");
        nationMap.put("纳西族","27");
        nationMap.put("景颇族","28");
        nationMap.put("柯尔克孜族","29");
        nationMap.put("土族","30");
        nationMap.put("达斡尔族","31");
        nationMap.put("仫佬族","32");
        nationMap.put("羌族","33");
        nationMap.put("布朗族","34");
        nationMap.put("撒拉族","35");
        nationMap.put("毛难族","36");
        nationMap.put("仡佬族","37");
        nationMap.put("锡伯族","38");
        nationMap.put("阿昌族","39");
        nationMap.put("普米族","40");
        nationMap.put("塔吉克族","41");
        nationMap.put("怒族","42");
        nationMap.put("乌孜别克族","43");
        nationMap.put("俄罗斯族","44");
        nationMap.put("鄂温克族","45");
        nationMap.put("崩龙族","46");
        nationMap.put("保安族","47");
        nationMap.put("裕固族","48");
        nationMap.put("京族","49");
        nationMap.put("塔塔尔族","50");
        nationMap.put("独龙族","51");
        nationMap.put("鄂伦春族","52");
        nationMap.put("赫哲族","53");
        nationMap.put("门巴族","54");
        nationMap.put("珞巴族","55");
        nationMap.put("基诺族","56");
        nationMap.put("其他","97");
        nationMap.put("外国血统中国籍人士","98");


        return nationMap.get(data);
    }



}
