package com.bcxin.obpm.dto.hunan;


/**
 * @author panxianwei
 * @date 2023/3/21 11:03
 */

public class DataItem {

    private String name;
    private String fmt;

    public DataItem(Builder builder) {
        this.name = builder.name;
        this.fmt = builder.fmt;
    }
    public DataItem() {
        this(new Builder());
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFmt() {
        return fmt;
    }

    public void setFmt(String fmt) {
        this.fmt = fmt;
    }

    public Builder newBuilder(){
        return new Builder(this);
    }

    @Override
    public String toString() {
        return "DataItem{" +
                "name='" + name + '\'' +
                ", fmt='" + fmt + '\'' +
                '}';
    }

    public static class Builder{
        private String name;
        private String fmt;

        public Builder() {
            name=name;
            fmt=fmt;
        }
        Builder(DataItem dataItem){
            this.name=dataItem.name;
            this.fmt=dataItem.fmt;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setFmt(String fmt) {
            this.fmt = fmt;
            return this;
        }
        public DataItem build(){
            return new DataItem(this);
        }

    }
}
