package com.bcxin.obpm.dto.Ministerial;

import com.bcxin.obpm.annotation.MinisterialAttr;
import com.bcxin.obpm.annotation.MinisterialEntity;
import lombok.Data;

/**
 * 海外经营信息管理
 * @author Ethan
 */
@Data
@MinisterialEntity(tableName = "tlk_overseasoperation")
public class Hwjyxx extends XxbaBaseDto {

	/**
	 *服务对象名称
	 */
	private String fwdxname;

	/**
	 *保安服务公司编码
	 */
	@MinisterialAttr(column = "(select item_companyCode from tlk_companyinformation sc where sc.item_domain_id = t1.item_domain_id LIMIT 1)", isSubQuery = true)
	private String bagsbm;

	/**
	 * 保安服务公司名称
	 */
	@MinisterialAttr(column = "ITEM_COMPANYNAME")
	private String bagsmc;

	/**
	 * 备注1
	 */
	private String bz1;

	/**

	 * 备注2
	 */
	private String bz2;

	/**
	 *  备注3
	 */
	private String bz3;

	/**
	 *  合同金额
	 */
	private String htje;

	/**
	 * 人员来源
	 * @return
	 */
	private String ryly;

	/**
	 *涉外经营国别
	 */
	@MinisterialAttr(column = "ITEM_nationality",defaultValue = "CHN")
	private String gj;

	/**
	 * 经营起始时间
	 */
	private String jyksrq;

	/**
	 * 经营结束时间
	 */
	private String jyjsrq;

	/**

	 * 经营模式
	 */
	private String jyms;

	/**
	 *  备案公安机关名称
	 */
	private String bajgmc;

	/**
	 *  备案日期
	 */
	private String barq;

	/**
	 * 保安服务类型
	 * @return
	 */
	private String fwlx;

}
