package com.bcxin.obpm.dto.Ministerial;

import com.bcxin.obpm.annotation.MinisterialAttr;
import com.bcxin.obpm.annotation.MinisterialEntity;
import lombok.Data;

/**
 * 保安服务公司信息实体类
 *
 * @author Wangjianchi
 */
@Data
@MinisterialEntity(tableName = "tlk_companyinformation",extraWhere = "AND item_officeType in ('0102','保安服务公司') and ITEM_isSub='1' and ITEM_registerAddress like '%#{nativeName}%'")
public class Bagsxxb extends XxbaBaseDto {
    /**
     * 保安服务公司编码
     */
    @MinisterialAttr(column = "item_companyCode")
    private String bagsbm;
    /**
     * 保安服务公司名称
     */
    @MinisterialAttr(column = "ITEM_companyName")
    private String bagsmc;
    /**
     * 国籍（地区）
     */
    @MinisterialAttr(column = "ITEM_nationality",defaultValue = "CHN")
    private String gj;
    /**
     * 注册地省市县（区）
     */
    //@MinisterialAttr(column = "areacode")
    private String zcd;
    /**
     * 注册地详址
     */
    @MinisterialAttr(column = "ITEM_registerAddressDetail")
    private String zcdxz;
    /**
     * 注册资金
     */
    @MinisterialAttr(column = "ITEM_registeredCapital",DATA_FORMAT = MinisterialDataFormat.AMOUNT)
    private String zczj;
    /**
     * 法定代表人公民身份号码
     */
    @MinisterialAttr(column = "ITEM_documentID")
    private String frsfzh;
    /**
     * 法定代表人姓名
     */
    @MinisterialAttr(column = "ITEM_legalPerson")
    private String frxm;
    /**
     * 法定代表人联系电话
     */
    //@MinisterialAttr(column = "(SELECT u.phone from `user` u where u.id = t1.user_id)",isSubQuery = true)
    //private String frdh;

    /**
     * 法定代表人联系电话
     */
    @MinisterialAttr(column = "ITEM_legalPersonPhone")
    private String frdh;

    /**
     * 负责人公民身份号码
     */
    //@MinisterialAttr(column = "principal_id")
    private String fzrsfzh;
    /**
     * 公司主要负责人姓名
     */
    //@MinisterialAttr(column = "principal")
    private String fzrxm;
    /**
     * 公司主要负责人联系电话
     */
    //@MinisterialAttr(column = "principal_phone")
    private String fzrdh;
    /**
     * 经济类型
     */
    @MinisterialAttr(column = "ITEM_economicType",DATA_FORMAT = MinisterialDataFormat.ECONOMIC_TYPE)
    private String jjlx;
    /**
     * 固定资产
     */
    @MinisterialAttr(column = "ITEM_fixedAssets",DATA_FORMAT = MinisterialDataFormat.AMOUNT)
    private String gdzc;
    /**
     * 年营业额
     */
    @MinisterialAttr(column = "ITEM_annuaTurnover",DATA_FORMAT = MinisterialDataFormat.AMOUNT)
    private String nyye;
    /**
     * 年利税
     */
    @MinisterialAttr(column = "ITEM_profitTaxes",DATA_FORMAT = MinisterialDataFormat.AMOUNT)
    private String nls;
    /**
     * 保安服务范围
     */
    @MinisterialAttr(column = "ITEM_businessScope",DATA_FORMAT = MinisterialDataFormat.SECURITYSCOPETYPE)
    private String fwlx;
    /**
     * 公司类型
     * 1:国有资本；
     * 2：民营；
     * 3：外资（包括港澳台投资）；
     * 4：其他
     */
    @MinisterialAttr(column = "ITEM_companyType",DATA_FORMAT = MinisterialDataFormat.COMPANYTYPE)
    private String gslx;
    /**
     * 保安服务许可证号
     */
    @MinisterialAttr(column = "ITEM_securityServicePermitNo", DATA_FORMAT = MinisterialDataFormat.REMOVE_CHINESE)
    private String bafwxkz;
    /**
     * 保安服务许可证发证机关编码
     */
    private String fzjgbm;
    /**
     * 保安服务许可证发证机关名称
     */
    @MinisterialAttr(column = "ITEM_issuingSecurityService")
    private String fzjgmc;
    /**
     * 保安服务许可证发证日期
     */
    @MinisterialAttr(column = "ITEM_issueServiceDate",DATE_FORMAT = "%Y%m%d")
    private String fzrq;
    /**
     * 保安服务许可证吊销机关
     */
    private String dxjg;
    /**
     * 保安服务许可证吊销日期
     */
    private String dxrq;
    /**
     * 人力防范等级
     */
    @MinisterialAttr(column = "ITEM_HRLevel",defaultValue = "0")
    private String rlffdj;
    /**
     * 武装守护押运等级
     */
    @MinisterialAttr(column = "ITEM_armedEscortLevel",defaultValue = "0")
    private String wzyydj;
    /**
     * 安全技术防范等级
     */
    @MinisterialAttr(column = "ITEM_securityPrecautions",defaultValue = "0")
    private String aqjsdj;
    /**
     * 风险评估等级
     */
    //@MinisterialAttr(column = "risk_assessment_level")
    private String fxpgdj;
    /**
     * 是否设立子公司
     */
    private String sfslzgs;
    /**
     * 子公司名称
     */
    private String zgsmc;
    /**
     * 备注1
     */
    private String bz1;
    /**
     * 备注2
     */
    private String bz2;
    /**
     * 备注3
     */
    private String bz3;
    /***
     * 客户数量
     */
    private  String khsl;
    /***
     * 变更标识 必填
     * 0：数据更新；
     * 1：名称变更；
     * 2：住所变更；
     * 3：法人变更；
     * 4：服务范围变更；
     */
    @MinisterialAttr(column = "\"0\"", isSubQuery = true)
    private String bgbs;
    /***
     * 自建金库
     */
    private String zjjk;



    @Override
    public String toString() {
        return "Bagsxxb{" +
                "bagsbm='" + bagsbm + '\'' +
                ", bagsmc='" + bagsmc + '\'' +
                ", gj='" + gj + '\'' +
                ", zcd='" + zcd + '\'' +
                ", zcdxz='" + zcdxz + '\'' +
                ", zczj=" + zczj +
                ", frsfzh='" + frsfzh + '\'' +
                ", frxm='" + frxm + '\'' +
                ", frdh='" + frdh + '\'' +
                ", fzrsfzh='" + fzrsfzh + '\'' +
                ", fzrxm='" + fzrxm + '\'' +
                ", fzrdh='" + fzrdh + '\'' +
                ", jjlx='" + jjlx + '\'' +
                ", gdzc=" + gdzc +
                ", nyye=" + nyye +
                ", nls=" + nls +
                ", fwlx='" + fwlx + '\'' +
                ", gslx='" + gslx + '\'' +
                ", bafwxkz='" + bafwxkz + '\'' +
                ", fzjgbm='" + fzjgbm + '\'' +
                ", fzjgmc='" + fzjgmc + '\'' +
                ", fzrq=" + fzrq +
                ", dxjg='" + dxjg + '\'' +
                ", dxrq=" + dxrq +
                ", rlffdj=" + rlffdj +
                ", wzyydj=" + wzyydj +
                ", aqjsdj=" + aqjsdj +
                ", fxpgdj=" + fxpgdj +
                ", sfslzgs=" + sfslzgs +
                ", zgsmc='" + zgsmc + '\'' +
                ", bz1='" + bz1 + '\'' +
                ", bz2='" + bz2 + '\'' +
                ", bz3='" + bz3 + '\'' +
                '}';
    }
}
