package com.bcxin.obpm.dto.Ministerial;

import com.bcxin.obpm.annotation.MinisterialAttr;
import com.bcxin.obpm.annotation.MinisterialEntity;
import lombok.Data;

/**
 * 保安服务公司跨区经营基本信息上报 实体类
 *
 * @author Wangjianchi
 */
@Data
@MinisterialEntity(tableName = "tlk_crossr")
public class Bafwgskqjyxx extends XxbaBaseDto {
    /**
     * 保安服务公司编码
     */
    @MinisterialAttr(column = "(select item_companyCode from tlk_companyinformation where tlk_companyinformation.item_domain_id = t1.item_domain_id  limit 1)", isSubQuery = true)
    private String bagsbm;
    /**
     * 经营地省市区（县）
     */
    @MinisterialAttr(column =  "ITEM_sonAddress")
    private String jydz;
    /**
     * 联系方式
     */
    @MinisterialAttr(column = "ITEM_chargePhone")
    private String lxfs;
    /**
     * 保安服务类型
     */
    private String fwlx;
    /**
     * 负责人公民身份号码
     */
    @MinisterialAttr(column = "ITEM_chargeCardnumber")
    private String fzrsfzh;
    /**
     * 负责人姓名
     */
    @MinisterialAttr(column = "ITEM_chargeName")
    private String fzrxm;
    /**
     * 负责人职务
     */
    @MinisterialAttr(column = "ITEM_chargePost")
    private String fzrzw;
    /**
     * 负责人联系电话
     */
    @MinisterialAttr(column = "ITEM_chargePhone")
    private String fzrdh;
    /**
     * 备案公安机关编码
     */
    private String bajgbm;
    /**
     * 备案公安机关名称
     */
    private String bajgmc;
    /**
     * 备案日期
     */
    private String barq;
    /**
     * 开始经营日期
     */
    private String ksjyrq;
    /**
     * 备注1
     */
    private String bz1;
    /**
     * 备注2
     */
    private String bz2;
    /**
     * 备注3
     */
    private String bz3;
    /**
     * 保安服务许可证号
     */
    @MinisterialAttr(column = "ITEM_licenceNum")
    private String bafwxkz;

}
