package com.bcxin.obpm.domain;

import com.bcxin.auth.common.core.domain.BaseEntity;
import com.bcxin.auth.serializer.LongJsonDeserializer;
import com.bcxin.auth.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

/**
 * 数据上报部级接口记录对象
 *
 * @table ministerial_log
 * @author linqinglin
 * @date 2021-03-04
 */
@Data
public class MinisterialLog extends BaseEntity {

    private static final long serialVersionUID=1L;
    /**
     * 主键
     */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long id;
    /**
     * 是否有效
     */
    private Boolean active;

    /**
     * 业务类型
     */
    private String businessType;

    /**
     * 交易流水号
     */
    private String serialNo;

    /**
     * 业务主键id
     */
    private String businessId;

    /**
     * 上报状态 0上报失败 1 上报成功
     */
    private String state;

    @Override
    public boolean equals(Object o){
        return super.equals(o);
    }

    @Override
    public int hashCode(){
        return super.hashCode();
    }

}

