package com.bcxin.auth.system.service.impl;


import com.alibaba.fastjson.JSON;
import com.bcxin.auth.common.config.BMSConfig;
import com.bcxin.auth.common.constant.Constants;
import com.bcxin.auth.common.exception.BusinessException;
import com.bcxin.auth.common.utils.bean.BeanUtils;
import com.bcxin.auth.system.domain.DataSyncLog;
import com.bcxin.auth.system.dto.datasync.DataSyncDto;
import com.bcxin.auth.system.mapper.DataSyncLogMapper;
import com.bcxin.auth.system.service.IDataSyncLogService;
import com.bcxin.auth.system.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * 数据同步记录Service业务层处理
 * 
 * @author lin
 * @date 2020-12-07
 */
@Service
public class DataSyncLogServiceImpl implements IDataSyncLogService {
    
    Logger logger = LoggerFactory.getLogger(DataSyncLogServiceImpl.class);
    
    @Autowired
    private DataSyncLogMapper dataSyncLogMapper;

    @Override
    public int delete(DataSyncLog dataSyncLog) {
        dataSyncLog.setUpdateTime(new Date());
        return dataSyncLogMapper.delete(dataSyncLog);
    }

    @Override
    public int save(DataSyncLog dataSyncLog) {
        if(dataSyncLog.getId() == null){
            dataSyncLog.setCreateTime(new Date());
        }else{
            DataSyncLog dbDataSyncLog = dataSyncLogMapper.findById(dataSyncLog.getId());
            BeanUtils.copyPropertiesIgnore(dataSyncLog,dbDataSyncLog,true);
            BeanUtils.copyPropertiesIgnore(dbDataSyncLog,dataSyncLog,false);
        }

        dataSyncLog.setUpdateTime(new Date());
        return dataSyncLogMapper.save(dataSyncLog);
    }

    @Override
    public void callback(DataSyncLog dataSyncLog) {
        DataSyncLog dbDataSyncLog = dataSyncLogMapper.findByMsgId(dataSyncLog.getMsgId());
        if(dbDataSyncLog != null){
            dbDataSyncLog.setDataSyncState(Constants.DATASYNCSTATE_2);
            dbDataSyncLog.setUpdateTime(new Date());
            dataSyncLogMapper.save(dbDataSyncLog);
        }
    }

    @Override
    public void receive(DataSyncDto dataSyncDto) throws Exception {
        DataSyncLog dataSyncLog = JSON.parseObject(dataSyncDto.getData(),DataSyncLog.class);
        try {
            FileUtil.downloadFile(dataSyncDto.getFilePaths(),dataSyncLog.getFilePath().replace(dataSyncLog.getBasePath(), BMSConfig.getDataSyncProfile()));
        }catch (Exception e){
            e.printStackTrace();
            throw new BusinessException("文件不存在："+dataSyncDto.getFilePaths());
        }
        dataSyncLog.setDataSyncState(Constants.DATASYNCSTATE_1);
        dataSyncLog.setErrorInfo(null);
        dataSyncLog.setUpdateTime(new Date());
        dataSyncLogMapper.save(dataSyncLog);
    }

    @Override
    public DataSyncLog findById(Long id) {
        return dataSyncLogMapper.findById(id);
    }

    @Override
    public List<DataSyncLog> findByBatchId(List<DataSyncLog> list) {
        return dataSyncLogMapper.findByBatchId(list);
    }

    @Override
    public void updateSelective(DataSyncLog dataSyncLog) {
        dataSyncLog.setUpdateTime(new Date());
        dataSyncLogMapper.updateSelective(dataSyncLog);
    }
}
