/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.obpm.util;

import java.io.ByteArrayOutputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;

public class RSAUtil {
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;

    public static KeyPair getKeyPair() throws Exception {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
        generator.initialize(1024);
        return generator.generateKeyPair();
    }

    public static PrivateKey getPrivateKey(String privateKey) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        byte[] decodedKey = Base64.decodeBase64((byte[])privateKey.getBytes());
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(decodedKey);
        return keyFactory.generatePrivate(keySpec);
    }

    public static PublicKey getPublicKey(String publicKey) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        byte[] decodedKey = Base64.decodeBase64((byte[])publicKey.getBytes());
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(decodedKey);
        return keyFactory.generatePublic(keySpec);
    }

    public static String encrypt(String data, String publicKeys) throws Exception {
        PublicKey publicKey = RSAUtil.getPublicKey(publicKeys);
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, publicKey);
        int inputLen = data.getBytes().length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offset = 0;
        int i = 0;
        while (inputLen - offset > 0) {
            byte[] cache = inputLen - offset > 117 ? cipher.doFinal(data.getBytes(), offset, 117) : cipher.doFinal(data.getBytes(), offset, inputLen - offset);
            out.write(cache, 0, cache.length);
            offset = ++i * 117;
        }
        byte[] encryptedData = out.toByteArray();
        out.close();
        return new String(Base64.encodeBase64String((byte[])encryptedData));
    }

    public static String decrypt(String data, String privateKeys) throws Exception {
        PrivateKey privateKey = RSAUtil.getPrivateKey(privateKeys);
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, privateKey);
        byte[] dataBytes = Base64.decodeBase64((String)data);
        int inputLen = dataBytes.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offset = 0;
        int i = 0;
        while (inputLen - offset > 0) {
            byte[] cache = inputLen - offset > 128 ? cipher.doFinal(dataBytes, offset, 128) : cipher.doFinal(dataBytes, offset, inputLen - offset);
            out.write(cache, 0, cache.length);
            offset = ++i * 128;
        }
        byte[] decryptedData = out.toByteArray();
        out.close();
        return new String(decryptedData, "UTF-8");
    }

    public static Map<String, String> genKeyPair() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>(2);
        KeyPair keyPair = RSAUtil.getKeyPair();
        String privateKey = new String(Base64.encodeBase64((byte[])keyPair.getPrivate().getEncoded()));
        String publicKey = new String(Base64.encodeBase64((byte[])keyPair.getPublic().getEncoded()));
        map.put("public", publicKey);
        map.put("private", privateKey);
        return map;
    }
}

