/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.obpm.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger logger = LoggerFactory.getLogger(DateUtil.class);
    public static String[] weekDays = new String[]{"\u5468\u65e5", "\u5468\u4e00", "\u5468\u4e8c", "\u5468\u4e09", "\u5468\u56db", "\u5468\u4e94", "\u5468\u516d"};
    public static SimpleDateFormat systemDate = new SimpleDateFormat("yyyy-MM-dd");
    public static SimpleDateFormat systemTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static SimpleDateFormat timestamp = new SimpleDateFormat("yyyyMMddhhmmss");
    public static SimpleDateFormat chinaDate = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
    public static SimpleDateFormat chinaTime = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 hh\u65f6mm\u5206");
    public static final String FORMAT1 = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT2 = "yyyy-MM-dd";
    public static final String FORMAT3 = "MM/dd/yyyy HH:mm:ss";
    public static final String FORMAT4 = "MM/dd/yyyy";
    public static final String FORMAT5 = "HH:mm:ss";
    public static final String FORMAT6 = "yyyy/MM/dd";
    public static final String FORMAT7 = "yyyy-MM-dd HH:mm";
    public static final String FORMAT8 = "yyyyMMddHHmmss";
    public static final String FORMAT9 = "yyyy-MM";
    public static final String FORMAT10 = "yyyy";
    public static final String FORMAT11 = "yyyyMMdd";
    public static final String FORMAT12 = "yyyyMMddHHmmssSSS";
    public static final String FORMAT13 = "yyyyMM";
    public static final String FORMAT14 = "HHmm";
    public static final String DATEFORMAT = "yyyy-MM-dd";
    public static final int DATATYPE_YEAR = 1;
    public static final int DATATYPE_MONTH = 2;
    public static final int DATATYPE_DAY = 3;
    public static final int DATATYPE_HOUR = 4;
    public static final int DATATYPE_MINUTE = 5;
    public static final int DATATYPE_SECOND = 6;

    public static String getWeekOfDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    public static String getWeekOfDate(String date) {
        try {
            Date d = systemDate.parse(date);
            return DateUtil.getWeekOfDate(d);
        }
        catch (ParseException e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.dateCompare("2018-07-10", "2018-07-09"));
    }

    public static List<String> getDatesBetweenDate(String startDate, String endDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<String> dates = new ArrayList<String>();
        try {
            Date dateOne = dateFormat.parse(startDate);
            Date dateTwo = dateFormat.parse(DateUtil.dateAdd(4, endDate, 24));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(dateOne);
            while (calendar.getTime().before(dateTwo)) {
                dates.add(dateFormat.format(calendar.getTime()));
                calendar.add(5, 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dates;
    }

    public static List<String> getThisWeekDates() {
        ArrayList<String> dates = new ArrayList<String>();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Calendar c = Calendar.getInstance();
            int dayOfWeek = c.get(7);
            if (c.getFirstDayOfWeek() == 1) {
                c.add(5, 1);
            }
            c.add(5, -dayOfWeek);
            for (int i = 1; i <= 7; ++i) {
                c.add(5, 1);
                dates.add(sdf.format(c.getTime()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dates;
    }

    public static List<String> getNextWeekDates() {
        ArrayList<String> dates = new ArrayList<String>();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Calendar c = Calendar.getInstance();
            int dayOfWeek = c.get(7);
            if (c.getFirstDayOfWeek() == 1) {
                c.add(5, 1);
            }
            c.add(5, -dayOfWeek + 7);
            for (int i = 1; i <= 7; ++i) {
                c.add(5, 1);
                dates.add(sdf.format(c.getTime()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dates;
    }

    public static int getDaysOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.getActualMaximum(5);
    }

    public static String getDayOfWeekByDate(String date) {
        String dayOfweek = "-1";
        try {
            String str;
            SimpleDateFormat myFormatter = new SimpleDateFormat("yyyy-MM-dd");
            Date myDate = myFormatter.parse(date);
            SimpleDateFormat formatter = new SimpleDateFormat("E");
            dayOfweek = str = formatter.format(myDate);
        }
        catch (Exception e) {
            System.out.println("\u9519\u8bef!");
        }
        return dayOfweek;
    }

    public static String getWeek(Date date) {
        String[] weeks = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int week_index = cal.get(7) - 1;
        if (week_index < 0) {
            week_index = 0;
        }
        return weeks[week_index];
    }

    public static Map<String, List<String>> getWeekDatesByYearMouth(String yearMouth) {
        LinkedHashMap<String, List<String>> weekDatesMap = new LinkedHashMap<String, List<String>>();
        ArrayList<String> oneList = new ArrayList<String>();
        ArrayList<String> twoList = new ArrayList<String>();
        ArrayList<String> threeList = new ArrayList<String>();
        ArrayList<String> fourList = new ArrayList<String>();
        ArrayList<String> fiveList = new ArrayList<String>();
        ArrayList<String> sixList = new ArrayList<String>();
        ArrayList<String> sevenList = new ArrayList<String>();
        int dayCount = DateUtil.getDaysOfMonth(DateUtil.convertStringToDate(yearMouth + "-01"));
        for (int day = 1; day <= dayCount; ++day) {
            String weekDay = yearMouth + "-" + (day > 9 ? Integer.valueOf(day) : "0" + day);
            String week = DateUtil.getWeek(DateUtil.convertStringToDate(weekDay));
            if (week.equals("\u661f\u671f\u4e00")) {
                oneList.add(weekDay);
                continue;
            }
            if (week.equals("\u661f\u671f\u4e8c")) {
                twoList.add(weekDay);
                continue;
            }
            if (week.equals("\u661f\u671f\u4e09")) {
                threeList.add(weekDay);
                continue;
            }
            if (week.equals("\u661f\u671f\u56db")) {
                fourList.add(weekDay);
                continue;
            }
            if (week.equals("\u661f\u671f\u4e94")) {
                fiveList.add(weekDay);
                continue;
            }
            if (week.equals("\u661f\u671f\u516d")) {
                sixList.add(weekDay);
                continue;
            }
            if (!week.equals("\u661f\u671f\u65e5")) continue;
            sevenList.add(weekDay);
        }
        weekDatesMap.put("\u5468\u4e00", oneList);
        weekDatesMap.put("\u5468\u4e8c", twoList);
        weekDatesMap.put("\u5468\u4e09", threeList);
        weekDatesMap.put("\u5468\u56db", fourList);
        weekDatesMap.put("\u5468\u4e03", fiveList);
        weekDatesMap.put("\u5468\u516d", sixList);
        weekDatesMap.put("\u5468\u5929", sevenList);
        return weekDatesMap;
    }

    public static int dateDiff(Date smdate, Date bdate) {
        if (smdate == null || bdate == null) {
            return 0;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            smdate = sdf.parse(sdf.format(smdate));
            bdate = sdf.parse(sdf.format(bdate));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(smdate);
        long time1 = cal.getTimeInMillis();
        cal.setTime(bdate);
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }

    public static String hourDiff(Date smdate, Date bdate) {
        String hour = "";
        String minute = "";
        if (smdate == null || bdate == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT1);
        try {
            smdate = sdf.parse(sdf.format(smdate));
            bdate = sdf.parse(sdf.format(bdate));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(smdate);
        double time1 = cal.getTimeInMillis();
        cal.setTime(bdate);
        double time2 = cal.getTimeInMillis();
        double between_hour = (time2 - time1) / 3600000.0;
        double between_minu = (time2 - time1) / 60000.0;
        hour = between_hour >= 1.0 ? (int)between_hour + "\u5c0f\u65f6" : "";
        if (between_minu % 60.0 > 0.0) {
            minute = (int)between_minu % 60 + "\u5206\u949f";
        }
        return hour + minute;
    }

    public static double hourDiff1(Date smdate, Date bdate, String pattern) {
        if (smdate == null || bdate == null) {
            return 0.0;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        try {
            smdate = sdf.parse(sdf.format(smdate));
            bdate = sdf.parse(sdf.format(bdate));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(smdate);
        double time1 = cal.getTimeInMillis();
        cal.setTime(bdate);
        double time2 = cal.getTimeInMillis();
        double between_hour = (time2 - time1) / 3600000.0;
        return between_hour;
    }

    public static int dateDiffForMinutes(Date smdate, Date bdate) {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT1);
        try {
            smdate = sdf.parse(sdf.format(smdate));
            bdate = sdf.parse(sdf.format(bdate));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(smdate);
        long time1 = cal.getTimeInMillis();
        cal.setTime(bdate);
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 60000L;
        return Integer.parseInt(String.valueOf(between_days));
    }

    public static Date dateAdd2(int type, Date date, int num) throws Exception {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (type == 1) {
            cal.add(1, num);
        } else if (type == 2) {
            cal.add(2, num);
        } else if (type == 4) {
            cal.add(10, num);
        } else if (type == 5) {
            cal.add(12, num);
        } else if (type == 6) {
            cal.add(13, num);
        } else {
            cal.add(5, num);
        }
        return cal.getTime();
    }

    public static String dateAdd(int type, String sdate, int num) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat(DateUtil.getFormat(sdate));
        Date date = df.parse(sdate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (type == 1) {
            cal.add(1, num);
        } else if (type == 2) {
            cal.add(2, num);
        } else if (type == 4) {
            cal.add(10, num);
        } else if (type == 5) {
            cal.add(12, num);
        } else if (type == 6) {
            cal.add(13, num);
        } else {
            cal.add(5, num);
        }
        return df.format(cal.getTime());
    }

    public static Date dateAdd(int type, Date date, int num) throws Exception {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (type == 1) {
            cal.add(1, num);
        } else if (type == 2) {
            cal.add(2, num);
        } else if (type == 4) {
            cal.add(10, num);
        } else if (type == 5) {
            cal.add(12, num);
        } else if (type == 6) {
            cal.add(13, num);
        } else {
            cal.add(5, num);
        }
        return cal.getTime();
    }

    public static int getCurrentMonthDay() {
        Calendar a = Calendar.getInstance();
        a.set(5, 1);
        a.roll(5, -1);
        int maxDate = a.get(5);
        return maxDate;
    }

    public static String getCurrentDate() {
        return DateUtil.getCurrentDateTime("yyyy-MM-dd");
    }

    public static String getYesterday() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        c.add(5, -1);
        return df.format(c.getTime());
    }

    public static String getTomorrow() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        c.add(5, 1);
        return df.format(c.getTime());
    }

    public static String getDateStrAfterToday(int day) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        c.add(5, day);
        return df.format(c.getTime());
    }

    public static String getCurrentDate(String format) {
        return DateUtil.getCurrentDateTime(format);
    }

    public static String getCurrentTime() {
        return DateUtil.getCurrentDateTime(FORMAT5);
    }

    public static String getCurrentDateTime() {
        return DateUtil.getCurrentDateTime(FORMAT1);
    }

    public static String getCurrentDateTime(String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(new Date());
    }

    public static int getDaysByYearMonth(int year, int month) {
        Calendar a = Calendar.getInstance();
        a.set(1, year);
        a.set(2, month - 1);
        a.set(5, 1);
        a.roll(5, -1);
        int maxDate = a.get(5);
        return maxDate;
    }

    public static String getFormat(String date) throws Exception {
        String reg1 = "\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}(.\\d{1,3}){0,1}";
        String reg2 = "\\d{4}-\\d{1,2}-\\d{1,2}";
        String reg3 = "\\d{1,2}/\\d{1,2}/\\d{4} \\d{1,2}:\\d{1,2}:\\d{1,2}(.\\d{1,3}){0,1}";
        String reg4 = "\\d{1,2}/\\d{1,2}/\\d{4}";
        String reg5 = "\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}";
        if (date.matches(reg1)) {
            return FORMAT1;
        }
        if (date.matches(reg2)) {
            return "yyyy-MM-dd";
        }
        if (date.matches(reg3)) {
            return FORMAT3;
        }
        if (date.matches(reg4)) {
            return FORMAT4;
        }
        if (date.matches(reg5)) {
            return FORMAT7;
        }
        throw new Exception("\u4e0d\u652f\u6301\u7684\u65e5\u671f\u683c\u5f0f\uff1a" + date);
    }

    public static String convertDateToString(Date date, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(date);
    }

    public static Date convertStringToDate(String date) {
        try {
            SimpleDateFormat df = new SimpleDateFormat(DateUtil.getFormat(date));
            return df.parse(date);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Date();
        }
    }

    public static long parseDate(String date) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm");
            return df.parse(date).getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static String getLastYear() {
        SimpleDateFormat format = new SimpleDateFormat(FORMAT10);
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(1, -1);
        Date y = c.getTime();
        String year = format.format(y);
        System.out.println("\u8fc7\u53bb\u4e00\u5e74\uff1a" + year);
        return year;
    }

    public static Date getDayBegin() {
        Date date = new Date();
        return DateUtil.getDayStartTime(date);
    }

    public static Date getDayEnd() {
        Date date = new Date();
        return DateUtil.getDayEndTime(date);
    }

    public static Date getBeginDayOfYesterday() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateUtil.getDayBegin());
        ((Calendar)cal).add(5, -1);
        return DateUtil.getDayStartTime(cal.getTime());
    }

    public static Date getEndDayOfYesterDay() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateUtil.getDayEnd());
        ((Calendar)cal).add(5, -1);
        return DateUtil.getDayEndTime(cal.getTime());
    }

    public static Date getBeginDayOfWeek() {
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 1 - dayofweek);
        return DateUtil.getDayStartTime(cal.getTime());
    }

    public static Date getEndDayOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getBeginDayOfWeek());
        cal.add(7, 6);
        Date weekEndSta = cal.getTime();
        return DateUtil.getDayEndTime(weekEndSta);
    }

    public static Date getBeginDayOfLastWeek() {
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, -7);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 1 - dayofweek);
        return DateUtil.getDayStartTime(cal.getTime());
    }

    public static Date getEndDayOfLastWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getBeginDayOfLastWeek());
        cal.add(7, 6);
        Date weekEndSta = cal.getTime();
        return DateUtil.getDayEndTime(weekEndSta);
    }

    public static Date getBeginDayOfMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(DateUtil.getNowYear(), DateUtil.getNowMonth() - 1, 1);
        return DateUtil.getDayStartTime(calendar.getTime());
    }

    public static Date getEndDayOfMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(DateUtil.getNowYear(), DateUtil.getNowMonth() - 1, 1);
        int day = calendar.getActualMaximum(5);
        calendar.set(DateUtil.getNowYear(), DateUtil.getNowMonth() - 1, day);
        return DateUtil.getDayEndTime(calendar.getTime());
    }

    public static Date getBeginDayOfLastMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(DateUtil.getNowYear(), DateUtil.getNowMonth() - 2, 1);
        return DateUtil.getDayStartTime(calendar.getTime());
    }

    public static Date getEndDayOfLastMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(DateUtil.getNowYear(), DateUtil.getNowMonth() - 2, 1);
        int day = calendar.getActualMaximum(5);
        calendar.set(DateUtil.getNowYear(), DateUtil.getNowMonth() - 2, day);
        return DateUtil.getDayEndTime(calendar.getTime());
    }

    public static Date getBeginDayOfYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, DateUtil.getNowYear());
        cal.set(2, 0);
        cal.set(5, 1);
        return DateUtil.getDayStartTime(cal.getTime());
    }

    public static Date getEndDayOfYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, DateUtil.getNowYear());
        cal.set(2, 11);
        cal.set(5, 31);
        return DateUtil.getDayEndTime(cal.getTime());
    }

    public static Date getBeginDayOfLastYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, DateUtil.getNowYear() - 1);
        cal.set(2, 0);
        cal.set(5, 1);
        return DateUtil.getDayStartTime(cal.getTime());
    }

    public static Date getEndDayOfLastYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, DateUtil.getNowYear() - 1);
        cal.set(2, 11);
        cal.set(5, 31);
        return DateUtil.getDayEndTime(cal.getTime());
    }

    public static Timestamp getDayStartTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Timestamp getDayEndTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Date getStartMonthDate(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, 1);
        return calendar.getTime();
    }

    public static Date getEndMonthDate(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, 1);
        int day = calendar.getActualMaximum(5);
        calendar.set(year, month - 1, day);
        return calendar.getTime();
    }

    public static Integer getNowYear() {
        Date date = new Date();
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        return gc.get(1);
    }

    public static int getNowMonth() {
        Date date = new Date();
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        return gc.get(2) + 1;
    }

    public static List<Date> getBetweenDates(Date start, Date end) {
        ArrayList<Date> result = new ArrayList<Date>();
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(start);
        Calendar tempEnd = Calendar.getInstance();
        tempEnd.setTime(end);
        while (tempStart.equals(tempEnd) || tempStart.before(tempEnd)) {
            result.add(tempStart.getTime());
            tempStart.add(6, 1);
        }
        return result;
    }

    public static boolean checkDate(String sourceDate) {
        if (sourceDate == null) {
            return false;
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            dateFormat.setLenient(false);
            dateFormat.parse(sourceDate);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean dateCompare(String strDate1, String strDate2) {
        boolean flag = false;
        if (strDate1 == null || strDate2 == null) {
            return flag;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date1 = dateFormat.parse(strDate1);
            Date date2 = dateFormat.parse(strDate2);
            flag = date1.getTime() <= date2.getTime();
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }
}

