/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.obpm.schedule;

import com.bcxin.auth.common.config.BMSConfig;
import com.bcxin.auth.common.utils.DateUtils;
import com.bcxin.auth.common.utils.file.FileUtils;
import com.bcxin.auth.system.service.ISysConfigService;
import com.bcxin.auth.system.util.ConfigUtil;
import com.bcxin.obpm.dto.AuthLog;
import com.bcxin.obpm.mapper.TenantUserMapper;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="photoDataSyncTask")
public class PhotoDataSyncTask {
    private static Logger logger = LoggerFactory.getLogger(PhotoDataSyncTask.class);
    @Autowired
    ISysConfigService configService;
    @Autowired
    ConfigUtil configUtil;
    @Autowired
    TenantUserMapper tenantUserMapper;
    private boolean lock = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.lock) {
            return;
        }
        this.lock = true;
        try {
            if (!this.configUtil.isIntranet()) {
                List<AuthLog> photoList = this.tenantUserMapper.queryPhotos(null);
                ArrayList<String> filePaths = new ArrayList<String>();
                if (photoList.size() > 0) {
                    for (AuthLog authLog : photoList) {
                        String fileName = this.configUtil.getDemoPath() + authLog.getImgPath();
                        filePaths.add(fileName);
                    }
                    if (filePaths.size() > 0) {
                        String fileName = BMSConfig.getTempPath() + "Photo_" + DateUtils.dateTimeNow((String)DateUtils.YYYYMMDDHHMMSS) + ".zip";
                        FileUtils.zipFiles(filePaths, (String)fileName);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
        finally {
            this.lock = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runForProvinceName(String provinceName) {
        if (this.lock) {
            return;
        }
        this.lock = true;
        try {
            if (!this.configUtil.isIntranet()) {
                List<AuthLog> photoList = this.tenantUserMapper.queryPhotos(provinceName);
                ArrayList<String> filePaths = new ArrayList<String>();
                if (photoList.size() > 0) {
                    for (AuthLog authLog : photoList) {
                        String fileName = this.configUtil.getDemoPath() + authLog.getImgPath();
                        filePaths.add(fileName);
                    }
                    if (filePaths.size() > 0) {
                        String fileName = BMSConfig.getTempPath() + "Photo_" + DateUtils.dateTimeNow((String)DateUtils.YYYYMMDDHHMMSS) + ".zip";
                        FileUtils.zipFiles(filePaths, (String)fileName);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
        finally {
            this.lock = false;
        }
    }

    public static void main(String[] args) throws Exception {
        String fileName = "/uploads/lib/img/142.png";
        fileName = fileName.substring(fileName.lastIndexOf("/"));
        String extendName = fileName.substring(fileName.lastIndexOf("."));
        File file = new File("d:/auth/temp/" + DateUtils.dateTimeNow((String)DateUtils.YYYY_MM_DD) + fileName);
        URL url = new URL("http://v5qy.baibaodun.cn/signon/uploads/lib/img/142.png");
        FileUtils.copyURLToFile((URL)url, (File)file, (int)30000, (int)30000);
        System.out.println(file.getAbsolutePath());
    }
}

