/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.obpm.schedule;

import com.alibaba.fastjson.JSONArray;
import com.bcxin.auth.system.service.ISysConfigService;
import com.bcxin.auth.system.util.ConfigUtil;
import com.bcxin.obpm.domain.MinisterialLog;
import com.bcxin.obpm.dto.Ministerial.MinisterialDataType;
import com.bcxin.obpm.dto.Ministerial.XxbaBaseDto;
import com.bcxin.obpm.dto.MinisterialAjaxResult;
import com.bcxin.obpm.service.MinisterialLogService;
import com.bcxin.obpm.util.MinisterialUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MinisterialAutoTask {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MinisterialLogService ministerialLogService;
    @Autowired
    private MinisterialUtil ministerialUtil;
    @Autowired
    private ConfigUtil configUtils;
    @Autowired
    private ISysConfigService configService;
    private boolean lock = false;

    public void run() {
        if (this.lock) {
            return;
        }
        this.lock = true;
        try {
            if (this.configUtils.isIntranet()) {
                this.syncRun();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.lock = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncRun() {
        String ministerial_limit = this.configService.selectConfigByKey("MINISTERIAL_LIMIT");
        int limit = 3;
        try {
            limit = Integer.parseInt(ministerial_limit);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (MinisterialDataType dataType : MinisterialDataType.values()) {
            try {
                List<Map> list = this.ministerialLogService.getBusinessDatas(dataType, limit);
                if (list == null || list.size() < 1) continue;
                List dataList = JSONArray.parseArray((String)JSONArray.toJSONString(list), (Class)dataType.getDataClazz());
                for (Object o : dataList) {
                    try {
                        MinisterialAjaxResult result = this.ministerialUtil.send(dataType, o);
                        this.logger.error("\u90e8\u7ea7\u4e0a\u62a5\u65e5\u5fd7\u7ed3\u679c\uff1a" + result.toString());
                        if (result.isSuccessful()) {
                            MinisterialLog log = new MinisterialLog();
                            log.setBusinessType(dataType.getCode());
                            if (result.getData() != null) {
                                log.setSerialNo(result.getData().toString());
                            }
                            log.setState("1");
                            log.setActive(true);
                            log.setCreateTime(new Date());
                            log.setUpdateTime(new Date());
                            log.setBusinessId(((XxbaBaseDto)o).getId());
                            this.logger.error("\u5f00\u59cb\u6dfb\u52a0\u65e5\u5fd7" + (Object)((Object)log));
                            this.ministerialLogService.save(log);
                            this.logger.error("\u7ed3\u675f\u6dfb\u52a0\u65e5\u5fd7");
                        }
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                        e.printStackTrace();
                    }
                }
                Thread.sleep(3000L);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
        }
    }
}

