/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.obpm.schedule;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.bcxin.auth.common.config.BMSConfig;
import com.bcxin.auth.common.utils.DES3;
import com.bcxin.auth.common.utils.DateUtils;
import com.bcxin.auth.system.domain.FileRecord;
import com.bcxin.auth.system.domain.SysConfig;
import com.bcxin.auth.system.mapper.FileRecordMapper;
import com.bcxin.auth.system.service.ISysConfigService;
import com.bcxin.auth.system.util.ConfigUtil;
import com.bcxin.obpm.dto.AuthLog;
import com.bcxin.obpm.service.ITenantUserService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="dataSyncTask")
public class DataSyncTask {
    private static Logger logger = LoggerFactory.getLogger(DataSyncTask.class);
    @Autowired
    ISysConfigService configService;
    @Autowired
    ConfigUtil configUtil;
    @Autowired
    ITenantUserService tenantUserService;
    @Autowired
    FileRecordMapper fileRecordMapper;
    private boolean lock = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block23: {
            if (this.lock) {
                return;
            }
            this.lock = true;
            try {
                if (this.configUtil.isIntranet()) break block23;
                String dataSyncDate = this.configService.selectConfigByKey("DATASYNC_DATE");
                if (StrUtil.isEmpty((CharSequence)dataSyncDate)) {
                    dataSyncDate = DateUtils.getYesterday();
                }
                Date startDate = DateUtils.dateTime((String)DateUtils.YYYY_MM_DD, (String)dataSyncDate);
                Date endDate = DateUtils.dateTime((String)DateUtils.YYYY_MM_DD, (String)DateUtils.getYesterday());
                if (startDate.getTime() > endDate.getTime()) {
                    dataSyncDate = DateUtils.getYesterday();
                }
                List dateList = DateUtils.getBetweenDates((String)dataSyncDate, (String)DateUtils.getTomorrow());
                for (Date date : dateList) {
                    try {
                        String dirFilePath = BMSConfig.getDataSyncProfile() + DateUtils.parseDateToStr((String)DateUtils.YYYY_MM_DD, (Date)date);
                        File dirFile = new File(dirFilePath);
                        if (!dirFile.getParentFile().exists()) {
                            dirFile.getParentFile().mkdirs();
                            continue;
                        }
                        if (!dirFile.exists()) continue;
                        File[] files = dirFile.listFiles();
                        ArrayList<String> filePaths = new ArrayList<String>();
                        for (int i = 0; i < files.length; ++i) {
                            File zipFile = files[i];
                            if (!zipFile.getName().endsWith(".zip")) continue;
                            ZipInputStream Zin = new ZipInputStream(new FileInputStream(zipFile));
                            BufferedInputStream Bin = new BufferedInputStream(Zin);
                            FileRecord fileRecord = this.fileRecordMapper.findByFileName(zipFile.getName());
                            if (fileRecord != null) continue;
                            String resultFilePath = BMSConfig.getTempPath() + File.separatorChar + DateUtils.getDate() + File.separatorChar;
                            File localFile = null;
                            try {
                                ZipEntry entry;
                                while ((entry = Zin.getNextEntry()) != null && !entry.isDirectory()) {
                                    int b;
                                    localFile = new File(resultFilePath, entry.getName());
                                    if (!localFile.exists()) {
                                        new File(localFile.getParent()).mkdirs();
                                    }
                                    FileOutputStream out = new FileOutputStream(localFile);
                                    BufferedOutputStream Bout = new BufferedOutputStream(out);
                                    while ((b = Bin.read()) != -1) {
                                        Bout.write(b);
                                    }
                                    Bout.close();
                                    out.close();
                                    if (localFile.getName().endsWith(".data")) {
                                        try {
                                            BufferedReader br = new BufferedReader(new FileReader(localFile));
                                            StringBuffer content = new StringBuffer();
                                            String lineTxt = null;
                                            while ((lineTxt = br.readLine()) != null) {
                                                content.append(lineTxt);
                                            }
                                            br.close();
                                            String jsonStr = DES3.decode((String)content.toString());
                                            TimeZone.setDefault(TimeZone.getTimeZone("GMT+8"));
                                            List list = JSONArray.parseArray((String)jsonStr, AuthLog.class);
                                            this.tenantUserService.updateBatchAuthStatusToCom(list);
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                            logger.error("\u8bfb\u53d6\u540c\u6b65\u6587\u4ef6\u5931\u8d25\uff1a{}", (Throwable)e);
                                        }
                                    }
                                    filePaths.add(localFile.getPath());
                                    logger.info(localFile + "\u89e3\u538b\u6210\u529f");
                                }
                                Bin.close();
                                Zin.close();
                            }
                            catch (IOException e) {
                                logger.error(e.getMessage());
                                throw e;
                            }
                            fileRecord = new FileRecord();
                            fileRecord.setFileName(zipFile.getName());
                            fileRecord.setFilePath(zipFile.getAbsolutePath());
                            fileRecord.setCreateTime(new Date());
                            fileRecord.setUpdateTime(new Date());
                            this.fileRecordMapper.save(fileRecord);
                        }
                        for (String filePath : filePaths) {
                            FileUtil.del((String)filePath);
                        }
                        SysConfig config = new SysConfig();
                        config.setConfigKey("DATASYNC_DATE");
                        config.setConfigValue(DateUtils.parseDateToStr((String)DateUtils.YYYY_MM_DD, (Date)date));
                        this.configService.updateConfigByKey(config);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(e.getMessage());
            }
            finally {
                this.lock = false;
            }
        }
    }
}

