/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.auth.system.util;

import com.bcxin.auth.common.utils.spring.SpringUtils;
import com.bcxin.auth.system.service.ISysConfigService;
import com.bcxin.obpm.service.BackgroundService;
import com.bcxin.zw.service.ZWService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ConfigUtil {
    @Value(value="${file.mode.host}")
    private String host;
    @Value(value="${file.mode.userName}")
    private String userName;
    @Value(value="${file.mode.password}")
    private String password;
    @Value(value="${file.mode.port}")
    private Integer port;
    @Value(value="${file.mode.useFtp}")
    private boolean useFtp;
    @Value(value="${file.mode.filePath}")
    private String filePath;
    @Value(value="${obpm.datasource.drive-class-name}")
    private String dbType;
    @Autowired
    private ISysConfigService configService;

    public Boolean getUseFtp() {
        return this.useFtp;
    }

    public String getHost() {
        return this.host;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public boolean isIntranet() {
        String intranet = this.configService.selectConfigByKey("INTRANET");
        return "1".equals(intranet);
    }

    public boolean isPolice() {
        String police = this.configService.selectConfigByKey("POLICE");
        return "1".equals(police);
    }

    public boolean isHNAuth() {
        String hnAuth = this.configService.selectConfigByKey("HN_AUTH");
        return "1".equals(hnAuth);
    }

    public String getValueByKey(String key) {
        String value = this.configService.selectConfigByKey(key);
        return value;
    }

    public boolean isTest() {
        String test = this.configService.selectConfigByKey("TEST");
        return "1".equals(test);
    }

    public boolean isTestSave() {
        String test = this.configService.selectConfigByKey("TESTSAVE");
        return !"0".equals(test);
    }

    public boolean isGSDB() {
        return this.dbType.equals("org.postgresql.Driver");
    }

    public boolean toFtp() {
        String toftp = this.configService.selectConfigByKey("TOFTP");
        return "1".equals(toftp);
    }

    public String getDemoPath() {
        return this.configService.selectConfigByKey("DEMO_PATH");
    }

    public String getV5URL() {
        return this.configService.selectConfigByKey("V5URL");
    }

    public String getV5IPURL() {
        return this.configService.selectConfigByKey("V5_IP_URL");
    }

    public String getLocalHostURL() {
        return this.configService.selectConfigByKey("LOCAL_HOST_URL");
    }

    public String getCurrentProvince() {
        return this.configService.selectConfigByKey("CURRENT_PROVINCE");
    }

    public String getCurrentNativeShort() {
        return this.configService.selectConfigByKey("current_native_short");
    }

    public String getCurrentNative() {
        return this.configService.selectConfigByKey("current_native");
    }

    public String getCurrentNativeName() {
        return this.configService.selectConfigByKey("current_native_name");
    }

    public BackgroundService getBackGroupService() {
        return (BackgroundService)SpringUtils.getBean((String)("backgroundService_" + this.getCurrentProvince()));
    }

    public ZWService getZWService() {
        return (ZWService)SpringUtils.getBean((String)("zwService_" + this.getCurrentProvince()));
    }

    public String getTimeUrl() {
        return this.configService.selectConfigByKey("SRC_HOST");
    }

    public String getTargetTimeUrl() {
        return this.configService.selectConfigByKey("TARGET_HOST");
    }

    public String getDataSyncFtpUrl() {
        return this.configService.selectConfigByKey("FTP_HOST");
    }

    public String getCreated() {
        return this.configService.selectConfigByKey("CREATED");
    }

    public List<String> getUnRemindList() {
        return this.configService.selectConfigByKeyList("BEIJING_BG_");
    }
}

