CREATE TABLE IF NOT EXISTS `fos_system` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `initialized` tinyint(4) NOT NULL DEFAULT '0',
     PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='系统初始化';

CREATE TABLE IF NOT EXISTS `dmm_dm_autoincrement_data` (
  `uuid` varchar(255) DEFAULT NULL COMMENT '唯一uuid',
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `createdAt` datetime DEFAULT NULL COMMENT '创建时间',
  `updatedAt` datetime DEFAULT NULL COMMENT '修改时间',
  `isDeleted` tinyint(1) DEFAULT '0' COMMENT '是否删除',
  `identifier` varchar(255) DEFAULT NULL COMMENT '标识符',
  `name` varchar(255) DEFAULT NULL COMMENT '英文名',
  `cnName` varchar(255) DEFAULT NULL COMMENT '中文名',
  `description` varchar(300) DEFAULT NULL COMMENT '描述/简介',
  `projectUuid` varchar(80) DEFAULT NULL COMMENT '项目uuid',
  `data` longtext COMMENT '数据',
  `modelUuid` varchar(80) DEFAULT NULL COMMENT '模型Uuid',
  `attributeUuid` varchar(80) DEFAULT NULL COMMENT '字段uuid',
  `tenantUuid` varchar(80) DEFAULT NULL COMMENT '租户uuid',
  PRIMARY KEY (`id`),
  KEY `ix_dmm_dm_autoincrement_data_identifier` (`identifier`),
  KEY `ix_dmm_dm_autoincrement_data_uuid` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COMMENT='自动编号序列';
