package com.wlos.app.vo;



import java.time.*;
import com.wlos.app.dto.CommonFileDTO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import lombok.Data;
import java.io.Serial;

/**
 * 开放问题表 数据查询通用VO
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:26 PM
 * @since v0.1
 */
@Data
public class BaseOpenIssueVO implements Serializable {
    @Serial
    private static final long serialVersionUID = -1L;

    /**
     * 主键id
     */
    private String id;

    /**
     * 踏勘题目
     */
    private String question;

    /**
     * 结果提示
     */
    private String answerTip;

    /**
     * 是否固定(是,否)
     */
    private String isFixed;

    /**
     * 踏勘次数
     */
    private String surveyCount;

    /**
     * 标签1
     */
    private String tagOne;

    /**
     * 标签2
     */
    private String tagTwo;

    /**
     * 标签3
     */
    private String tagThire;



}