package com.wlos.app.utils;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 * @ClassName VoUtils
 * @Author Tazerotoo
 * @Date 2023/10/9 13:22
 * vo 处理
 */
@Slf4j
public class VoUtils {

    public static JSONObject handleFileVo(JSONObject vo, String[] returnDataKeyList){
        //标识是是否是文件下载
        vo.put(Constants.DOWN_FILE_FLAG_KEY, Constants.DOWN_FILE_FLAG_VALUE_0);
        AtomicBoolean checkFile = new AtomicBoolean(false);
        Arrays.stream(returnDataKeyList).forEach(item -> {
            if (StringUtils.isBlank(item)) {
                return;
            }
            Object data = vo.get(item);
            boolean flag = checkReturnFile(data);
            //判断获取的值是否为文件下载的数据
            if (flag) {
                checkFile.set(true);
                vo.put("system_flow_down_file_key_value_name", item);
            }
            if (checkFile.get()) {
                vo.put(Constants.DOWN_FILE_FLAG_KEY, Constants.DOWN_FILE_FLAG_VALUE_1);
            }
        });
        return vo;
    }

    /**
     * 判断返回值是否为文件输出
     *
     * @param value
     * @return
     */
    public static boolean checkReturnFile(Object value) {
        boolean isReturnFile = false;
        try {
            //判断存储的文件是否为文件下载节点输出的数据：文件下载节点输出的数据格式为json格式，且存在特殊标识符 DOWN_FILE_FLAG_KEY
            if (null != value && !"".equals(value) && value instanceof Map) {
                JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(value));
                if (jsonObject.containsKey(Constants.DOWN_FILE_FLAG_KEY)
                        && jsonObject.get(Constants.DOWN_FILE_FLAG_KEY).equals(Constants.DOWN_FILE_FLAG_VALUE_1)) {
                    isReturnFile = true;
                }
            }
        } catch (Exception e) {
            log.error("操作异常", e);
        }
        return isReturnFile;
    }

}
