package com.wlos.app.utils;

import com.wlos.app.dto.EnvironmentVariableDTO;

/**
 * 线程变量：token 用户信息
 * @author
 * @date
 */
public class UserSessionContext {

    private static final ThreadLocal<String> THREAD_LOCAL_TOKEN = new ThreadLocal<>();
    private static final ThreadLocal<EnvironmentVariableDTO> THREAD_LOCAL_ENVIRONMENT_VARIABLE = new ThreadLocal<>();

    public static void setToken(String token) {
        THREAD_LOCAL_TOKEN.set(token);
    }

    public static String getToken() {
       return  THREAD_LOCAL_TOKEN.get();
    }

    public static void setEnvironmentVariable(EnvironmentVariableDTO environmentVariable){
        THREAD_LOCAL_ENVIRONMENT_VARIABLE.set(environmentVariable);
    }

    public static EnvironmentVariableDTO getEnvironmentVariable() {
        return  THREAD_LOCAL_ENVIRONMENT_VARIABLE.get();
    }

    public static void remove() {
        THREAD_LOCAL_TOKEN.remove();
        THREAD_LOCAL_ENVIRONMENT_VARIABLE.remove();
    }
}