package com.wlos.app.utils;

import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.HttpServletRequest;

/**
 * 权限获取工具类
 *
 * @author
 * @date 
 */
public class SecurityUtils {
    /**
     * 令牌自定义标识
     */
    public static final String AUTHENTICATION = "Authorization";
    /**
     * 令牌前缀
     */
    public static final String PREFIX = "Bearer ";

    /**
     * 获取请求token
     */
    public static String getToken() {
        return getToken(ServletUtils.getRequest());
    }

    /**
     * 根据request获取请求token
     */
    public static String getToken(HttpServletRequest request) {
        // 从header获取token标识
        String token = request.getHeader(AUTHENTICATION);
        return replaceTokenPrefix(token);
    }


    /**
     * 根据request获取请求token
     */
    public static String getPreviousToken(HttpServletRequest request) {
        // 从header获取token标识
        return request.getHeader(AUTHENTICATION);
    }

    /**
     * 裁剪token前缀
     */
    public static String replaceTokenPrefix(String token) {
        // 如果前端设置了令牌前缀，则裁剪掉前缀
        if (StringUtils.isNotEmpty(token) && token.startsWith(PREFIX)) {
            token = token.replaceFirst(PREFIX, "");
        }
        return token;
    }
}
