package com.wlos.app.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.github.pagehelper.Page;

import java.util.List;

/**
 * page result
 * @param <T>
 */
public class PageResult<T> {

    /**
     * 页码
     */
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer pageNum;
    /**
     * 页数
     */
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer pageSize;
    /**
     * 总页数
     */
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer totalPages;
    /**
     * 总条数
     */
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Long totalElements;

    /**
     * 数据列表
     */
    private List<T> list;

    public static <T> PageResult<T> of(Page<T> page) {
        PageResult<T> pageResult = new PageResult<>();
        pageResult.setList(page.getResult());

        if (isPage(page.getPageSize())) {
            pageResult.setTotalElements(page.getTotal());
            pageResult.setTotalPages(page.getPages());
            pageResult.setPageNum(page.getPageNum());
            pageResult.setPageSize(page.getPageSize());
        }
        return pageResult;
    }

    public static <T> PageResult<T> valueOf(List<T> list) {
        PageResult<T> pageResult = new PageResult<>();
        pageResult.setList(list);
        return pageResult;
    }

    public static <R, T> PageResult<R> valueOf(Page<T> page, List<R> list) {
        PageResult<R> pageResult = new PageResult<>();
        pageResult.setList(list);

        if (isPage(page.getPageSize())) {
            pageResult.setTotalElements(page.getTotal());
            pageResult.setTotalPages(page.getPages());
            pageResult.setPageNum(page.getPageNum());
            pageResult.setPageSize(page.getPageSize());
        }
        return pageResult;
    }

    public static boolean isPage(int pageSize) {
        return Integer.MAX_VALUE != pageSize;
    }

    private PageResult() {
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getTotalPages() {
        return totalPages;
    }

    public void setTotalPages(Integer totalPages) {
        this.totalPages = totalPages;
    }

    public Long getTotalElements() {
        return totalElements;
    }

    public void setTotalElements(Long totalElements) {
        this.totalElements = totalElements;
    }

    public List<T> getList() {
        return list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }
}

