package com.wlos.app.utils;

import com.wlos.app.exception.BusinessException;
import io.jsonwebtoken.*;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @Author ldw
 * @Date 2021/3/15 11:12
 * @Description
 **/
@Component
public class JwtUtil {

    protected final Logger log = LoggerFactory.getLogger(getClass());
    private String privateKey = "MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCySCug0gUCI3S7lyCKCDCLJsSknBxe3ysu1+AYKbwbfQDQm5K5ouwsIWwaz+GYFjkLst1AluO7hmmrl021pVE9hGb9DogoEz6niAqasurwjunvWEPigjVjxRoN4N4QFLzTgPld5A9OMQF8unlRwX+jBn19yNsCm1zAoqMOmPdGK/RVlcEHPd6amcmnrYfQ+M4XO+49PyAGQzazuaEugKFiCPZzfcSE2d5bZDEqx2BQRRbMK37mMP/N4Lj+EQ8BXNl7FtHQmEOyZj+iUeq7fZ80MHQRz+YrIknZ8jNC8KR7BBrilpIvvhWyG121yKLJnsBbwL986lGEDcdkDz6/np1TAgMBAAECggEANwmgrl0nvqlDeEYHfZVZpxuoyUiIWaF7q1JplAwOTk4g2kWs3jI1xsnqnbxfYJw7sCjftPjgBRxRsu9axiDrG5qsUKMT1YtbZEzTOT7S2MDF52XQTzTzVoGasX4iD8TXJlRCp4GoV/M5ClBm855Q0PtH8nT3Z66ey7lprS/75mVV4PUFgjtqvM1hqFnS9BD5llwWd+nWqyKqBuQ9i6PeNGevInGgBIxUwrFjU+JGtTroOKDudsqVCkT6WUoKesIDPOkSWR7WIGcohJVB7zSot70DCGlUkauGjzP51sOwbz9JroZwhjJN5SWWKQZzhmksjtvaKl0yFdZy0CJN4r11gQKBgQC26Fmx0p9yqYYHjfpWFXgF5t3SfC18ddwdDuIwWpvIP2nbHBURdjPIJUypQH6d26QqksCWjjzRehTx3Hhtu1NMCtuMyh6Vw8e3k/NBRqDDCeyRuGT3Mo+x61LK2WEZLhO4qMNb/dkJUcQt92rT138eR5JGsAeENYDyHZASqPIs+QKBgQD5hpsHUcKY/AIQLJXMBvfAgRLwE0Kmb8qKL/KdRHBqSiBTzGqXchlD4GCKLTmK/XcmFKh233tewMpnStc9tTpEd97CNr65lSuG/xziSfX3CReDIODmVC5GnQCsMu4ZYmcCMLaTqzqISJwUVDk1UyO+7YISR/wNWCjqPz63aaLrqwKBgQCu0oZooJgmUEH7FokfnoWJnpCGjoorW7t3SrKG5RPg4jubYcwBVKlJs90CKNLcrwLKbloFjQ40ait6wO+acmG7XOVcPBPfsbFClfb7fTZLNUEYRta6L2mI9RO9LujP2GqhJS0U0ByR+8U26jUBJggqON5nEfkdNMZ6pCcArtpKgQKBgQCnNbF7lSlvNSj4x7fWEjFB2fzjzjRSrgUu1vSguLUQNP42yXwAYqBVoO1wit/NqQ6IAT3m8tmMZGr+DuPv4RrbuOwYf3ENkc2qWBh195QQ6BHOeGDdWDnubdV+j16Iui1HBXfDuvGtU+LrqIjxl/YTQrtwHrbkBljcqGcRp4NaowKBgCmNpUxy1TNkv5xRB+Msi+xeVSnGE0B5LTmG6F+w11zq1HNWcMgsVI6c8kCD0G6lEC6jI+4oY3wLG4luolynrmpGDDPGRMuef9mVXboleLKLgXFCYbr2nB1N1OWnsRMJwHHk/nmCrUc0aniDXWP+a+4GlYhyxPe0DI3w0DG6vdX/";
    private String publicKey = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAskgroNIFAiN0u5cgiggwiybEpJwcXt8rLtfgGCm8G30A0JuSuaLsLCFsGs/hmBY5C7LdQJbju4Zpq5dNtaVRPYRm/Q6IKBM+p4gKmrLq8I7p71hD4oI1Y8UaDeDeEBS804D5XeQPTjEBfLp5UcF/owZ9fcjbAptcwKKjDpj3Riv0VZXBBz3empnJp62H0PjOFzvuPT8gBkM2s7mhLoChYgj2c33EhNneW2QxKsdgUEUWzCt+5jD/zeC4/hEPAVzZexbR0JhDsmY/olHqu32fNDB0Ec/mKyJJ2fIzQvCkewQa4paSL74VshtdtciiyZ7AW8C/fOpRhA3HZA8+v56dUwIDAQAB";

    /***
     * 生成jwt
     * @param subject 主题
     * @param claimsMap 用户信息
     * @param expiraTime 过期时间 不传默认1小时
     * @return
     * @throws Exception
     */
    public String createJWT(String subject, Map<String, Object> claimsMap, Long expiraTime) throws Exception {
        long nowMillis = System.currentTimeMillis();
        Date now = new Date(System.currentTimeMillis());
        Map<String, Object> var1 = new HashMap<>();
        var1.put("alg", "RS256");
        var1.put("typ", "JWT");
        KeyFactory kf = KeyFactory.getInstance("RSA");

        PrivateKey privKey = kf.generatePrivate(new PKCS8EncodedKeySpec(Base64.decodeBase64(privateKey)));

        JwtBuilder builder = Jwts.builder()
                .setHeader(var1)
                .setId(String.valueOf(claimsMap.get(UserSession.USER_UUID)))
                .setIssuedAt(now)
                .setIssuer(String.valueOf(claimsMap.get(UserSession.USERNAME)))
                .setClaims(claimsMap)
                .setSubject(subject)
                .signWith(SignatureAlgorithm.RS256, privKey);
        /** 设置过期时间  单位：秒*/
        long expMillis = nowMillis;
        if (expiraTime == null || -1L == expiraTime) {
            expiraTime = 12 * 60L * 60L * 1000;
        }
        expMillis += expiraTime;
        Date exp = new Date(expMillis);
        builder.setExpiration(exp);
        String token = builder.compact();
        log.info("生成 token :{}", token);
        return token;
    }

    /***
     * 生成jwt
     * @param subject 主题
     * @param privateKeyStr 私钥
     * @param claimsMap 用户信息
     * @param expiraTime 过期时间 不传默认1小时
     * @return
     * @throws Exception
     */
    public String createJWT(String subject, String privateKeyStr, Map<String, Object> claimsMap, Long expiraTime) throws Exception {
        long nowMillis = System.currentTimeMillis();
        Date now = new Date(System.currentTimeMillis());
        Map<String, Object> var1 = new HashMap<>();
        var1.put("alg", "RS256");
        var1.put("typ", "JWT");
        KeyFactory kf = KeyFactory.getInstance("RSA");

        privateKeyStr = StringUtils.isBlank(privateKeyStr) ? privateKey : privateKeyStr;

        PrivateKey privKey = kf.generatePrivate(new PKCS8EncodedKeySpec(Base64.decodeBase64(privateKeyStr)));

        JwtBuilder builder = Jwts.builder()
                .setHeader(var1)
                .setSubject(subject)
                .setIssuedAt(now)
                .setClaims(claimsMap)
                .signWith(SignatureAlgorithm.RS256, privKey);
        /** 设置过期时间  单位：秒*/
        long expMillis = nowMillis;
        if (expiraTime == null || -1L == expiraTime) {
            expiraTime = 12 * 60L * 60L * 1000;
        }
        expMillis += expiraTime;
        Date exp = new Date(expMillis);
        builder.setExpiration(exp);
        String token = builder.compact();
        log.info("生成 token :{}", token);

        return token;
    }

    public Map<String, Object> checkToken(String token) {
        Map<String, Object> tokenBody = new HashMap<>();
        if (StringUtils.isEmpty(token)) {
            return null;
        }
        //        if (!redisService.hasKey(token)) {
//            throw new BusinessException("请登录后再重试");
//        }
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PublicKey pubkey = kf.generatePublic(new X509EncodedKeySpec(Base64.decodeBase64(publicKey)));
            tokenBody = Jwts.parser()
                    .setSigningKey(pubkey)
                    .parseClaimsJws(token)
                    .getBody();
            tokenBody.put(Constants.FLAG, Constants.SUCCESS);
        } catch (Exception e) {
            tokenBody.put(Constants.FLAG, Constants.FAIL);
        }

        return tokenBody;
    }

    public Map<String, Object> checkJwtToken(String token, String privateKeyStr) {
        Map<String, Object> tokenBody = new HashMap<>();
        if (StringUtils.isEmpty(token)) {
            return null;
        }
        privateKeyStr = StringUtils.isBlank(privateKeyStr) ? privateKey : privateKeyStr;

        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");

            PrivateKey privateKey = kf.generatePrivate(new X509EncodedKeySpec(Base64.decodeBase64(privateKeyStr)));
            tokenBody = Jwts.parser()
                    .setSigningKey(privateKey)
                    .parseClaimsJws(token)
                    .getBody();
            tokenBody.put(Constants.FLAG, Constants.SUCCESS);
        } catch (Exception e) {
            return null;
        }

        return tokenBody;
    }

    //解析token
    public Claims getClaimsFromToken(String token,String privateKeyStr) throws Exception {
        Claims claims;
        try {
            if (StringUtils.isEmpty(token)) {
                return null;
            }
            privateKeyStr = StringUtils.isBlank(privateKeyStr) ? privateKey : privateKeyStr;

            KeyFactory kf = KeyFactory.getInstance("RSA");
            PublicKey pubkey = kf.generatePublic(new X509EncodedKeySpec(Base64.decodeBase64(privateKeyStr)));
            claims = Jwts.parser()
                    .setSigningKey(pubkey)
                    .parseClaimsJws(token)
                    .getBody();
        } catch (ExpiredJwtException e) {
            claims = e.getClaims();
        }
        return claims;
    }

    public Boolean isTokenExpired(String token) {
        final Date expiration = getExpirationDateFromToken(token);
        return expiration.before(new Date());
    }

    //得到token到期时间
    public Date getExpirationDateFromToken(String token) {
        Date expiration;
        try {
            final Claims claims = getClaimsFromToken(token,null);
            expiration = claims.getExpiration();
        } catch (Exception e) {
            expiration = null;
        }
        return expiration;
    }

    //刷新token
    public String refreshToken(String token, Long expiraTime) {
        String refreshedToken = null;
        if (StringUtils.isEmpty(token)) {
            return null;
        }
        try {
            final Claims claims = getClaimsFromToken(token,null);
            if (claims != null) {
                refreshedToken = createJWT(claims.getSubject(), claims, expiraTime);
            }
        } catch (Exception e) {
        }
        return refreshedToken;
    }

    public String refreshJwtToken(String token,String publicKeyStr, String privateKeyStr,Long expiraTime) {
        String refreshedToken = null;
        if (StringUtils.isEmpty(token)) {
            return null;
        }
        try {
            final Claims claims = getClaimsFromToken(token, privateKeyStr);
            if (claims != null) {
                refreshedToken = createJWT(claims.getSubject(), publicKeyStr,claims, expiraTime);
            }
        } catch (Exception e) {
            refreshedToken = null;
        }
        return refreshedToken;
    }

    //将redis token 设置过期
    public void abandonToken(String token) {

//        redisService.expire(token, 1L);
    }

}