package com.wlos.app.utils;


import com.wlos.app.model.vo.OperateCondition;
import com.wlos.app.utils.Constants;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.ObjectUtils;
import com.alibaba.fastjson.JSONObject;
import java.util.List;


/**
 * TODO
 *
 * @author jiangnan
 * @date 2023-12-11 10:15
 * @since 1.0
 */
public class FuncUtils {



    public static <T> QueryWrapper<T> funSimple(String func, String funcColumn, T condition) {
        QueryWrapper<T> codeTemplateQueryWrapper = new QueryWrapper<>(condition);

        if (Constants.MAX_FUNC.equals(func)) {
            codeTemplateQueryWrapper.select(String.format("%s(%s) as %s", func, funcColumn, func));
        } else if (Constants.MIN_FUNC.equals(func)) {
            codeTemplateQueryWrapper.select(String.format("%s(%s) as %s", func, funcColumn, func));
        } else if (Constants.SUM_FUNC.equals(func)) {
            codeTemplateQueryWrapper.select(String.format("%s(%s) as %s", func, funcColumn, func));
        } else if (Constants.COUNT_FUNC.equals(func)) {
            codeTemplateQueryWrapper.select(String.format("%s(*) as %s", func, func));
        }
        return codeTemplateQueryWrapper;
    }

    public static <T> QueryWrapper<T> funcByGroup(OperateCondition operateCondition) {
         QueryWrapper<T> codeTemplateQueryWrapper = new QueryWrapper<>();

        String func = operateCondition.getFunc();
        String funcColumn = operateCondition.getFuncColumn();
        String groupColumn = operateCondition.getGroupColumn();
        if (Constants.MAX_FUNC.equals(func)) {
            codeTemplateQueryWrapper.select(String.format("%s(%s) as %s", func, funcColumn, func), groupColumn);
        } else if (Constants.MIN_FUNC.equals(func)) {
            codeTemplateQueryWrapper.select(String.format("%s(%s) as %s", func, funcColumn, func), groupColumn);
        } else if (Constants.SUM_FUNC.equals(func)) {
            codeTemplateQueryWrapper.select(String.format("%s(%s) as %s", func, funcColumn, func), groupColumn);
        } else if (Constants.COUNT_FUNC.equals(func)) {
            codeTemplateQueryWrapper.select(String.format("%s(*) as %s", func, func), groupColumn);
        }
        codeTemplateQueryWrapper.groupBy(groupColumn);
        
        buildWhere(operateCondition.getWhereList(), codeTemplateQueryWrapper);

        //添加Having
        if (ObjectUtils.isNotEmpty(operateCondition.getHavingList())) {
            for (OperateCondition.Having having : operateCondition.getHavingList()) {
                String operator = having.getOperator();
                String sqlOperator = "";
                switch (operator) {
                    case Constants.equal, "=" -> sqlOperator = "=";
                    case Constants.notEqual, "!=" -> sqlOperator = "!=";
                    case Constants.greaterThan, ">" -> sqlOperator = ">";
                    case Constants.greaterThanOrEqualT0, ">=" -> sqlOperator = ">=";
                    case Constants.lessThan, "<" -> sqlOperator = "<";
                    case Constants.lessThanOrEqualTo, "<=" -> sqlOperator = "<=";
                    case Constants.in -> sqlOperator = "in";
                    case Constants.notIn, "not in " -> sqlOperator = "not in";
                }
                codeTemplateQueryWrapper.having(having.getColumn() + sqlOperator + " {0}", having.getValue());
            }
        }


        return codeTemplateQueryWrapper;
    }



    public static <T> void buildWhere(List<OperateCondition.Having> whereList , QueryWrapper<T> codeTemplateQueryWrapper) {
        if(ObjectUtils.isNotEmpty(whereList)){
            for (OperateCondition.Having where : whereList) {
                String operator = where.getOperator();
                String column = where.getColumn();
                Object value = where.getValue();
                switch (operator) {
                    case Constants.equal -> codeTemplateQueryWrapper.eq(column, value);
                    case Constants.notEqual -> codeTemplateQueryWrapper.ne(column, value);
                    case Constants.isNull -> codeTemplateQueryWrapper.isNull(column);
                    case Constants.isNotNull -> codeTemplateQueryWrapper.isNotNull(column);
                    case Constants.greaterThan -> codeTemplateQueryWrapper.gt(column, value);
                    case Constants.greaterThanOrEqualT0 -> codeTemplateQueryWrapper.ge(column, value);
                    case Constants.lessThan -> codeTemplateQueryWrapper.lt(column, value);
                    case Constants.lessThanOrEqualTo -> codeTemplateQueryWrapper.le(column, value);
                    case Constants.startsWith -> codeTemplateQueryWrapper.likeLeft(column, value);
                    case Constants.endsWith -> codeTemplateQueryWrapper.likeRight(column, value);
                    case Constants.contains -> codeTemplateQueryWrapper.like(column, value);
                    case Constants.notContains -> codeTemplateQueryWrapper.notLike(column, value);
                    case Constants.in -> codeTemplateQueryWrapper.in(column, JSONObject.parseArray(JSONObject.toJSONString(value)));
                    case Constants.notIn -> codeTemplateQueryWrapper.notIn(column, JSONObject.parseArray(JSONObject.toJSONString(value)));
                }
            }
        }
    }
}
