package com.wlos.app.utils;

import cn.hutool.core.util.RandomUtil;
import com.wlos.app.exception.BusinessException;
import org.apache.commons.lang3.ObjectUtils;

import java.math.BigDecimal;
import java.util.*;

public class BlocklyMathUtils {

    public static boolean isNumber(Object arg0) {
        /*return switch (arg0) {
            case Integer integer -> true;
            case Double aDouble -> true;
            case BigDecimal bigDecimal -> true;
            case String string -> {
                try {
                    new BigDecimal(string);
                    yield true;
                } catch (Exception e) {
                    yield false;
                }
            }
            case null, default -> arg0 instanceof Float;
        };*/

        return false;
    }

    /**
     * 加法运算：+
     * @param arg0
     * @param arg1
     * @return
     */
    public static Object mathArithmeticAdd(Object arg0, Object arg1) {
        if (isNumber(arg0) && isNumber(arg1)) {
            return new BigDecimal(String.valueOf(arg0)).add(new BigDecimal(String.valueOf(arg1)));
        } else {
            return ObjectUtils.isNotEmpty(arg0) ? String.valueOf(arg0) : "" + (ObjectUtils.isNotEmpty(arg1) ? arg1 : "");
        }
    }

    /**
     * 减法运算：-
     * @param arg0
     * @param arg1
     * @return
     * @throws BusinessException
     */
    public static Object mathArithmeticMinus(Object arg0, Object arg1) throws BusinessException {
        if (!isNumber(arg0) || !isNumber(arg1)) {
            throw new BusinessException("非法数值不能参与运算");
        }
        return new BigDecimal(String.valueOf(arg0)).subtract(new BigDecimal(String.valueOf(arg1)));
    }

    /**
     * 乘法运算：*
     * @param arg0
     * @param arg1
     * @return
     */
    public static Object mathArithmeticMultiply(Object arg0, Object arg1) {
        if (!isNumber(arg0) || !isNumber(arg1)) {
            throw new BusinessException("非法数值不能参与运算");
        }
        return new BigDecimal(String.valueOf(arg0)).multiply(new BigDecimal(String.valueOf(arg1)));
    }

    /**
     * 除法运算：/
     * @param arg0
     * @param arg1
     * @return
     */
    public static Object mathArithmeticDivide(Object arg0, Object arg1) {
        if (!isNumber(arg0) || !isNumber(arg1)) {
            throw new BusinessException("非法数值不能参与运算");
        }
        return new BigDecimal(String.valueOf(arg0)).divide(new BigDecimal(String.valueOf(arg1)));
    }

    /**
     * pow：^
     * @param arg0
     * @param arg1
     * @return
     */
    public static double mathArithmeticPow(Object arg0, Object arg1) {
        if (!isNumber(arg0) || !isNumber(arg1)) {
            throw new BusinessException("非法数值不能参与运算");
        }
        return Math.pow(Double.parseDouble(String.valueOf(arg0)), Double.parseDouble(String.valueOf(arg1)));
    }

    /**
     * sqrt
     * @param arg0
     * @return
     */
    public static double mathSingleSqrt(Object arg0) {
        if (!isNumber(arg0)) {
            throw new BusinessException("非法数值不能参与运算");
        }
        return Math.sqrt(Double.parseDouble(String.valueOf(arg0)));
    }

    /**
     * abs
     * @param arg0
     * @return
     */
    public static double mathSingleAbs(Object arg0) {
        if (!isNumber(arg0)) {
            throw new BusinessException("非法数值不能参与运算");
        }

        return Math.abs(Double.parseDouble(String.valueOf(arg0)));
    }

    /**
     * neg
     * @param arg0
     * @return
     */
    public static Object mathSingleNeg(Object arg0) {
        if (!isNumber(arg0)) {
            throw new BusinessException("非法数值不能参与运算");
        }
        return new BigDecimal(String.valueOf(arg0)).negate();
    }

    /**
     * ln
     * @param arg0
     * @return
     */
    public static double mathSingleLn(Object arg0) {
        if (!isNumber(arg0)) {
            throw new BusinessException("非法数值不能参与运算");
        }
        return Math.log(Double.parseDouble(String.valueOf(arg0)));
    }

    /**
     * log10
     * @param arg0
     * @return
     */
    public static double mathSingleLog10(Object arg0) {
        if (!isNumber(arg0)) {
            throw new BusinessException("非法数值不能参与运算");
        }
        return Math.log10(Double.parseDouble(String.valueOf(arg0)));
    }

    /**
     * exp
     * @param arg0
     * @return
     */
    public static double mathSingleExp(Object arg0) {
        if (!isNumber(arg0)) {
            throw new BusinessException("非法数值不能参与运算");
        }
        return Math.exp(Double.parseDouble(String.valueOf(arg0)));
    }

    /**
     * pow10
     * @param arg0
     * @return
     */
    public static double mathSinglePow10(Object arg0) {
        if (!isNumber(arg0)) {
            throw new BusinessException("非法数值不能参与运算");
        }
        return Math.pow(10, Double.parseDouble(String.valueOf(arg0)));
    }

    /**
     * sin
     * @param arg0
     * @return
     */
    public static double mathTrigSin(Object arg0) {
        if (!isNumber(arg0)) {
            throw new BusinessException("非法数值不能参与运算");
        }
        double degrees = Double.parseDouble(String.valueOf(arg0));
        double radians = Math.toRadians(degrees);
        return Math.sin(radians);
    }

    /**
     * cos
     * @param arg0
     * @return
     */
    public static double mathTrigCos(Object arg0) {
        if (!isNumber(arg0)) {
            throw new BusinessException("非法数值不能参与运算");
        }
        double degrees = Double.parseDouble(String.valueOf(arg0));
        double radians = Math.toRadians(degrees);
        return Math.cos(radians);
    }

    /**
     * tan
     * @param arg0
     * @return
     */
    public static double mathTrigTan(Object arg0) {
        if (!isNumber(arg0)) {
            throw new BusinessException("非法数值不能参与运算");
        }
        double degrees = Double.parseDouble(String.valueOf(arg0));
        double radians = Math.toRadians(degrees);
        return Math.tan(radians);
    }

    /**
     * asin
     * @param arg0
     * @return
     */
    public static double mathTrigAsin(Object arg0) {
        if (!isNumber(arg0)) {
            throw new BusinessException("非法数值不能参与运算");
        }
        return Math.toDegrees(Math.asin(Double.parseDouble(String.valueOf(arg0))));
    }

    /**
     * acos
     * @param arg0
     * @return
     */
    public static double mathTrigAcos(Object arg0) {
        if (!isNumber(arg0)) {
            throw new BusinessException("非法数值不能参与运算");
        }
        return Math.toDegrees(Math.acos(Double.parseDouble(String.valueOf(arg0))));
    }

    /**
     * atan
     * @param arg0
     * @return
     */
    public static double mathTrigAtan(Object arg0) {
        if (!isNumber(arg0)) {
            throw new BusinessException("非法数值不能参与运算");
        }
        return Math.toDegrees(Math.atan(Double.parseDouble(String.valueOf(arg0))));
    }

    /**
     * round
     * @param arg0
     * @return
     */
    public static long mathRound(Object arg0) {
        if (!isNumber(arg0)) {
            throw new BusinessException("非法数值不能参与运算");
        }
        return Math.round(Double.parseDouble(String.valueOf(arg0)));
    }

    /**
     * round up
     * @param arg0
     * @return
     */
    public static double mathRoundUp(Object arg0) {
        if (!isNumber(arg0)) {
            throw new BusinessException("非法数值不能参与运算");
        }
        return Math.ceil(Double.parseDouble(String.valueOf(arg0)));
    }

    /**
     * round down
     * @param arg0
     * @return
     */
    public static double mathRoundDown(Object arg0) {
        if (!isNumber(arg0)) {
            throw new BusinessException("非法数值不能参与运算");
        }
        return Math.floor(Double.parseDouble(String.valueOf(arg0)));
    }

    /**
     * modulo % 求余
     * @param arg0
     * @param arg1
     * @return
     */
    public static Object mathModulo(Object arg0, Object arg1) {
        if (!isNumber(arg0) || !isNumber(arg1)) {
            throw new BusinessException("非法数值不能参与运算");
        }
        return new BigDecimal(String.valueOf(arg0)).remainder(new BigDecimal(String.valueOf(arg1)));
    }

    /**
     * random int
     * @param arg0
     * @param arg1
     * @return
     */
    public static int mathRandomInt(Object arg0, Object arg1) {
        if (!isNumber(arg0) || !isNumber(arg1)) {
            throw new BusinessException("非法数值不能参与运算");
        }

        double arg0Double = Math.ceil(Double.parseDouble(String.valueOf(arg0)));
        double arg1Double = Math.ceil(Double.parseDouble(String.valueOf(arg1)));

        if (arg0Double > arg1Double) {
            double c = arg0Double;
            arg0Double = arg1Double;
            arg1Double = c;
        }
        return RandomUtil.randomInt((int) arg0Double, (int) arg1Double);
    }

    /**
     * 列表中数值的和
     * @param arg0
     * @return
     */
    public static BigDecimal mathOnListSum(Object arg0) {
        if (ObjectUtils.isEmpty(arg0)) return BigDecimal.ZERO;
        //对象转换为list
        List<Object> list = new ArrayList<>();
        return list.stream().map(x -> ObjectUtils.isNotEmpty(x) ? new BigDecimal(String.valueOf(x)) : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    /**
     * 列表中数值的最小
     * @param arg0
     * @return
     */
    public static Object mathOnListMin(Object arg0) {
        if (ObjectUtils.isEmpty(arg0)) return null;
        //对象转换为list
        List list = new ArrayList();

        return list.stream().min(Comparator.comparing(item -> new BigDecimal(String.valueOf(item)))).orElse(null);
    }

    /**
     * 列表中数值的最大
     * @param arg0
     * @return
     */
    public static Object mathOnListMax(Object arg0) {
        if (ObjectUtils.isEmpty(arg0)) return null;
        //对象转换为list
        List list = new ArrayList();
        return list.stream().max(Comparator.comparing(item -> new BigDecimal(String.valueOf(item)))).orElse(null);
    }

    /**
     * 列表中数值的平均值
     * @param arg0
     * @return
     */
    public static BigDecimal mathOnListAverage(Object arg0) {
        if (ObjectUtils.isEmpty(arg0)) return BigDecimal.ZERO;
        //对象转换为list
        List list = new ArrayList();
        return mathOnListSum(list).divide(new BigDecimal(list.size()));
    }

    /**
     * 列表中数值的中位数
     * @param arg0
     * @return
     */
    public static Object mathOnListMedian(Object arg0) {
        if (ObjectUtils.isEmpty(arg0)) return null;
        //对象转换为list
        List list = new ArrayList();
        //集合排序
        Collections.sort(list);
        int size = list.size();
        if(size % 2 == 0){
            return  (new BigDecimal(String.valueOf(list.get(size/2-1)))).add(new BigDecimal(String.valueOf(list.get(size/2)))).divide(new BigDecimal(2));
        }else {
            return list.get((size-1)/2);
        }
    }

    /**
     * 列表中数值的众数
     * @param arg0
     * @return
     */
    public static Object mathOnListMode(Object arg0) {
        if (ObjectUtils.isEmpty(arg0)) return null;
        //对象转换为list
        List argList = new ArrayList();
        Map<Object, Integer> map = new HashMap<>();
        Set<Map.Entry<Object, Integer>> set = map.entrySet();
        // 结果
        List modes = new ArrayList<>();
        // 统计元素出现的次数，存入Map集合
        for (Object item : argList) {
            map.put(item, map.getOrDefault(item, 0) + 1);
        }
        List<Integer> counts = (List<Integer>) map.values();
        //集合排序
        Collections.sort(counts);
        // 得到最大值
        int max = counts.get(counts.size() - 1);
        // 根据最大值获取众数
        for (Map.Entry<Object, Integer> entry : set) {
            if (entry.getValue() == max) {
                modes.add(entry.getKey());
            }
        }
        return modes;
    }

    //variance 样本方差
   public static double variance(List arg0) {
       double variance = 0;
       for (int i = 0; i < arg0.size(); i++) {
            variance +=  mathArithmeticPow(mathArithmeticMinus(arg0.get(i), mathOnListAverage(arg0)), 2);
       }
       variance = variance/(arg0.size() - 1);
       return variance;
    }


    /**
     * 列表中数值的标准差
     * @param arg0
     * @return
     */
    public static double mathOnListStdDev(Object arg0) {
        if (ObjectUtils.isEmpty(arg0)) return 0;
        //对象转换为list
        List argList = new ArrayList();
        return Math.sqrt(variance(argList));
    }

    /**
     * 列表中数值的随机一项
     * @param arg0
     * @return
     */
    public static Object mathOnListRandom(Object arg0) {
        if (ObjectUtils.isEmpty(arg0)) return null;
        List argList = new ArrayList();
        return argList.get(RandomUtil.randomInt(argList.size()));
    }

}
