package com.wlos.app.model.vo;

import com.wlos.app.enums.AnalysisEnums;

/**
 * 图表分析模型
 */
public class AnalysisDataDTO {

    private String uuid;
    /**
     * 数据类型
     */
    private String dataType;
    /**
     * 数据表唯一标识
     */
    private String tableUuid;
    /**
     * 数据列中文名称
     */
    private String columnCnName;
    /**
     * 数据列列唯一标识
     */
    private String columnUuid;
    /**
     * 日期格式化
     */
    private String formatter;
    /**
     * 指标类型（维度、度量）
     */
    private String mode;
    /**
     * 排序（升序、降序）
     */
    private Integer rankType;
    /**
     * 数据特点（离散、连续）
     */
    private String type;
    /**
     * 度量-类型（求和、平均、最大值、最小值、计数、中位数）
     */
    private String aggregateType;

    private AnalysisEnums.Axis axis;

    private boolean isJoinTable;

    public String getTableUuid() {
        return tableUuid;
    }

    public void setTableUuid(String tableUuid) {
        this.tableUuid = tableUuid;
    }

    public String getColumnUuid() {
        return columnUuid;
    }

    public void setColumnUuid(String columnUuid) {
        this.columnUuid = columnUuid;
    }

    public String getFormatter() {
        return formatter;
    }

    public void setFormatter(String formatter) {
        this.formatter = formatter;
    }

    public String getMode() {
        return mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public Integer getRankType() {
        return rankType;
    }

    public void setRankType(Integer rankType) {
        this.rankType = rankType;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAggregateType() {
        return aggregateType;
    }

    public void setAggregateType(String aggregateType) {
        this.aggregateType = aggregateType;
    }

    public String getUuid() {
        return uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getDataType() {
        return dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getColumnCnName() {
        return columnCnName;
    }

    public void setColumnCnName(String columnCnName) {
        this.columnCnName = columnCnName;
    }

    public AnalysisEnums.Axis getAxis() {
        return axis;
    }

    public void setAxis(AnalysisEnums.Axis axis) {
        this.axis = axis;
    }

    public boolean isJoinTable() {
        return isJoinTable;
    }

    public void setJoinTable(boolean joinTable) {
        isJoinTable = joinTable;
    }
}
