package com.wlos.app.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.*;
import com.wlos.app.dto.CommonFileDTO;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableField;
import java.time.*;

/**
 * 勘查项目 实体类
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:26 PM
 * @since v0.1
 */
@TableName(resultMap = "BaseResultMap",value = "survey_project")
public class SurveyProject implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * 主键id
     */
    @TableId(value = "id",type = IdType.AUTO)
    private String id;

    /**
     * 创建时间
     */
    @TableField(value = "creation_time")
    private LocalDateTime creationTime;

    /**
     * 修改时间
     */
    @TableField(value = "modification_time")
    private LocalDateTime modificationTime;

    /**
     * CMS中对应的问题ID
     */
    @TableField(value = "aid")
    private String aid;

    /**
     * 结果提示
     */
    @TableField(value = "answer_tip")
    private String answerTip;

    /**
     * 踏勘题目
     */
    @TableField(value = "question")
    private String question;

    /**
     * 问题类型
     */
    @TableField(value = "question_type")
    private String questionType;

    /**
     * 排序编号
     */
    @TableField(value = "sort")
    private Long sort;

    /**
     * 踏勘阶段
     */
    @TableField(value = "survey_step")
    private String surveyStep;

    /**
     * 问题回答id
     */
    @TableField(value = "survey_info_id")
    private Long survey_info_id;




    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return id;
    }

    public void setCreationTime(LocalDateTime creationTime) {
        this.creationTime = creationTime;
    }

    public LocalDateTime getCreationTime() {
        return creationTime;
    }

    public void setModificationTime(LocalDateTime modificationTime) {
        this.modificationTime = modificationTime;
    }

    public LocalDateTime getModificationTime() {
        return modificationTime;
    }

    public void setAid(String aid) {
        this.aid = aid;
    }

    public String getAid() {
        return aid;
    }

    public void setAnswerTip(String answerTip) {
        this.answerTip = answerTip;
    }

    public String getAnswerTip() {
        return answerTip;
    }

    public void setQuestion(String question) {
        this.question = question;
    }

    public String getQuestion() {
        return question;
    }

    public void setQuestionType(String questionType) {
        this.questionType = questionType;
    }

    public String getQuestionType() {
        return questionType;
    }

    public void setSort(Long sort) {
        this.sort = sort;
    }

    public Long getSort() {
        return sort;
    }

    public void setSurveyStep(String surveyStep) {
        this.surveyStep = surveyStep;
    }

    public String getSurveyStep() {
        return surveyStep;
    }

    public void setSurvey_info_id(Long survey_info_id) {
        this.survey_info_id = survey_info_id;
    }

    public Long getSurvey_info_id() {
        return survey_info_id;
    }



}