package com.wlos.app.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.*;
import com.wlos.app.dto.CommonFileDTO;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableField;
import java.time.*;

/**
 * 查勘现场照片 实体类
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:26 PM
 * @since v0.1
 */
@TableName(resultMap = "BaseResultMap",value = "survey_photo")
public class SurveyPhoto implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * 主键id
     */
    @TableId(value = "id",type = IdType.AUTO)
    private String id;

    /**
     * 创建时间
     */
    @TableField(value = "creation_time")
    private LocalDateTime creationTime;

    /**
     * 修改时间
     */
    @TableField(value = "modification_time")
    private LocalDateTime modificationTime;

    /**
     * 阿里OSSKEY
     */
    @TableField(value = "oss_key")
    private String ossKey;

    /**
     * 图片路径
     */
    @TableField(value = "path")
    private String path;

    /**
     * 所属踏勘整改ID
     */
    @TableField(value = "correction_id")
    private Long correctionId;

    /**
     * 踏勘信息ID
     */
    @TableField(value = "survey_info_id")
    private Long surveyInfoId;

    /**
     * 微信图片路径
     */
    @TableField(value = "media_id")
    private String mediaId;




    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return id;
    }

    public void setCreationTime(LocalDateTime creationTime) {
        this.creationTime = creationTime;
    }

    public LocalDateTime getCreationTime() {
        return creationTime;
    }

    public void setModificationTime(LocalDateTime modificationTime) {
        this.modificationTime = modificationTime;
    }

    public LocalDateTime getModificationTime() {
        return modificationTime;
    }

    public void setOssKey(String ossKey) {
        this.ossKey = ossKey;
    }

    public String getOssKey() {
        return ossKey;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return path;
    }

    public void setCorrectionId(Long correctionId) {
        this.correctionId = correctionId;
    }

    public Long getCorrectionId() {
        return correctionId;
    }

    public void setSurveyInfoId(Long surveyInfoId) {
        this.surveyInfoId = surveyInfoId;
    }

    public Long getSurveyInfoId() {
        return surveyInfoId;
    }

    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }

    public String getMediaId() {
        return mediaId;
    }



}