package com.wlos.app.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.*;
import com.wlos.app.dto.CommonFileDTO;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableField;
import java.time.*;

/**
 * 勘查协助 实体类
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:27 PM
 * @since v0.1
 */
@TableName(resultMap = "BaseResultMap",value = "survey_assist")
public class SurveyAssist implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * 主键id
     */
    @TableId(value = "id")
    private String id;

    /**
     * 创建时间
     */
    @TableField(value = "creation_time")
    private LocalDateTime creationTime;

    /**
     * 修改时间
     */
    @TableField(value = "modification_time")
    private LocalDateTime modificationTime;

    /**
     * 分配状态(0未审批;1不通过;2通过;9关闭)
     */
    @TableField(value = "assign_status")
    private String assignStatus;

    /**
     * 分配类型(0任务转交;1申请专家)
     */
    @TableField(value = "assign_type")
    private String assignType;

    /**
     * 申请的专家
     */
    @TableField(value = "experts")
    private Object experts;

    /**
     * 申请原因
     */
    @TableField(value = "reason")
    private String reason;

    /**
     * 踏勘阶段
     */
    @TableField(value = "survey_step")
    private String surveyStep;

    /**
     * 接受者
     */
    @TableField(value = "accepter_id")
    private Long accepterId;

    /**
     * 踏勘任务ID
     */
    @TableField(value = "task_id")
    private Long taskId;

    /**
     * 用户ID
     */
    @TableField(value = "user_id")
    private Long userId;




    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return id;
    }

    public void setCreationTime(LocalDateTime creationTime) {
        this.creationTime = creationTime;
    }

    public LocalDateTime getCreationTime() {
        return creationTime;
    }

    public void setModificationTime(LocalDateTime modificationTime) {
        this.modificationTime = modificationTime;
    }

    public LocalDateTime getModificationTime() {
        return modificationTime;
    }

    public void setAssignStatus(String assignStatus) {
        this.assignStatus = assignStatus;
    }

    public String getAssignStatus() {
        return assignStatus;
    }

    public void setAssignType(String assignType) {
        this.assignType = assignType;
    }

    public String getAssignType() {
        return assignType;
    }

    public void setExperts(Object experts) {
        this.experts = experts;
    }

    public Object getExperts() {
        return experts;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getReason() {
        return reason;
    }

    public void setSurveyStep(String surveyStep) {
        this.surveyStep = surveyStep;
    }

    public String getSurveyStep() {
        return surveyStep;
    }

    public void setAccepterId(Long accepterId) {
        this.accepterId = accepterId;
    }

    public Long getAccepterId() {
        return accepterId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public Long getTaskId() {
        return taskId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getUserId() {
        return userId;
    }



}