package com.wlos.app.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.*;
import com.wlos.app.dto.CommonFileDTO;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableField;
import java.time.*;

/**
 * 固定问题表 实体类
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:26 PM
 * @since v0.1
 */
@TableName(resultMap = "BaseResultMap",value = "base_fixed_issue")
public class BaseFixedIssue implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * 主键id
     */
    @TableId(value = "id")
    private String id;

    /**
     * 踏勘题目
     */
    @TableField(value = "question")
    private String question;

    /**
     * 结果提示
     */
    @TableField(value = "answer_tip")
    private String answerTip;

    /**
     * 排序编号
     */
    @TableField(value = "sort")
    private Integer sort;

    /**
     * 是否固定(是,否)
     */
    @TableField(value = "is_fixed")
    private String isFixed;

    /**
     * 踏勘阶段(第1阶段,第2阶段,第3阶段)
     */
    @TableField(value = "survey_step")
    private String surveyStep;

    /**
     * 活动类型
     */
    @TableField(value = "activity_type")
    private String activityType;

    /**
     * 地址类型
     */
    @TableField(value = "address_type")
    private String addressType;

    /**
     * 是否通用，1是，0否
     */
    @TableField(value = "gm")
    private String gm;




    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return id;
    }

    public void setQuestion(String question) {
        this.question = question;
    }

    public String getQuestion() {
        return question;
    }

    public void setAnswerTip(String answerTip) {
        this.answerTip = answerTip;
    }

    public String getAnswerTip() {
        return answerTip;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public Integer getSort() {
        return sort;
    }

    public void setIsFixed(String isFixed) {
        this.isFixed = isFixed;
    }

    public String getIsFixed() {
        return isFixed;
    }

    public void setSurveyStep(String surveyStep) {
        this.surveyStep = surveyStep;
    }

    public String getSurveyStep() {
        return surveyStep;
    }

    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    public String getActivityType() {
        return activityType;
    }

    public void setAddressType(String addressType) {
        this.addressType = addressType;
    }

    public String getAddressType() {
        return addressType;
    }

    public void setGm(String gm) {
        this.gm = gm;
    }

    public String getGm() {
        return gm;
    }



}