package com.wlos.app.enums;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.EnumUtils;
import com.wlos.app.exception.BusinessException;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 模型枚举
 */
public class ModelAttributeEnum {

    private static final Map<ModelType, List<Attribute>> MODELS = new HashMap<>();


	static {

	List<Attribute> baseDictAttributes = new ArrayList<>();
	MODELS.put(ModelType.baseDict,baseDictAttributes);
	List<Attribute> surveyReformAttributes = new ArrayList<>();
	MODELS.put(ModelType.surveyReform,surveyReformAttributes);
	List<Attribute> surveyProjectTempAttributes = new ArrayList<>();
	MODELS.put(ModelType.surveyProjectTemp,surveyProjectTempAttributes);
	List<Attribute> surveyTagAttributes = new ArrayList<>();
	MODELS.put(ModelType.surveyTag,surveyTagAttributes);
	List<Attribute> surveyExpertAttributes = new ArrayList<>();
	MODELS.put(ModelType.surveyExpert,surveyExpertAttributes);
	List<Attribute> baseOpenIssueAttributes = new ArrayList<>();
	MODELS.put(ModelType.baseOpenIssue,baseOpenIssueAttributes);
	List<Attribute> surveyInfoAttributes = new ArrayList<>();
	MODELS.put(ModelType.surveyInfo,surveyInfoAttributes);
	List<Attribute> surveyFeedbackAttributes = new ArrayList<>();
	MODELS.put(ModelType.surveyFeedback,surveyFeedbackAttributes);
	List<Attribute> surveyPhotoAttributes = new ArrayList<>();
	MODELS.put(ModelType.surveyPhoto,surveyPhotoAttributes);
	List<Attribute> surveySignAttributes = new ArrayList<>();
	MODELS.put(ModelType.surveySign,surveySignAttributes);
	List<Attribute> surveyProjectAttributes = new ArrayList<>();
	MODELS.put(ModelType.surveyProject,surveyProjectAttributes);
	List<Attribute> baseFixedIssueAttributes = new ArrayList<>();
	MODELS.put(ModelType.baseFixedIssue,baseFixedIssueAttributes);
	List<Attribute> baseRegionAttributes = new ArrayList<>();
	MODELS.put(ModelType.baseRegion,baseRegionAttributes);
	List<Attribute> surveyAssistAttributes = new ArrayList<>();
	MODELS.put(ModelType.surveyAssist,surveyAssistAttributes);
	List<Attribute> surveyQuestionnaireAttributes = new ArrayList<>();
	MODELS.put(ModelType.surveyQuestionnaire,surveyQuestionnaireAttributes);
	List<Attribute> surveyUserAttributes = new ArrayList<>();
	MODELS.put(ModelType.surveyUser,surveyUserAttributes);
	List<Attribute> surveyPlanAttributes = new ArrayList<>();
	MODELS.put(ModelType.surveyPlan,surveyPlanAttributes);
	List<Attribute> surveyTaskAttributes = new ArrayList<>();
	MODELS.put(ModelType.surveyTask,surveyTaskAttributes);
	List<Attribute> venueInformationAttributes = new ArrayList<>();
	MODELS.put(ModelType.venueInformation,venueInformationAttributes);	}
	public enum ModelType {
baseDict,surveyReform,surveyProjectTemp,surveyTag,surveyExpert,baseOpenIssue,surveyInfo,surveyFeedback,surveyPhoto,surveySign,surveyProject,baseFixedIssue,baseRegion,surveyAssist,surveyQuestionnaire,surveyUser,surveyPlan,surveyTask,venueInformation,	;
	}    
    public record Attribute(String uuid, String enName, Object extData) {}
    public record FormulaSetting(String rule, String parameters){}
    public record AutoincFieldSetting(String rule, Integer reset, Integer incStart, Integer incLength){}


    public static List<Attribute> getAttribute(String modelType) {
        return  MODELS.get(EnumUtils.getEnum(ModelType.class, modelType));
    }

    public static Attribute getAttribute(String modelType,String field) {
        List<Attribute> attributes = MODELS.get(EnumUtils.getEnum(ModelType.class, modelType));
        Optional<Attribute> first = attributes.stream().filter(item -> item.enName.equals(field)).findFirst();
        return first.orElseThrow(()->new BusinessException("自动编号字段不存在"));
    }


    public static String getAttributeAsKey(String asKey) {
        Map<String, String> keyMap = Maps.newHashMap();
        List<Map<ModelType, List<Attribute>>> list= List.of(MODELS);
        list.forEach(m -> {
            m.forEach((modelType, value) -> value.forEach(a -> {
                String key = modelType.name() + "__" + a.enName;
                keyMap.put(key, modelType.name() + "_" + a.enName);
            }));
        });
        return Optional.ofNullable(keyMap.get(asKey)).orElse(asKey);
    }   

    public static void main(String[] args) {
        List<Attribute> attributes = ModelAttributeEnum.getAttribute("Staff");
        System.out.println(attributes);
    }
}    