package com.wlos.app.dto;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import java.math.BigDecimal;
import java.time.*;
import java.util.*;
import com.wlos.app.dto.*;
import com.wlos.app.model.*;
import javax.validation.*;
import javax.validation.constraints.*;

/**
 * 新增场馆信息请求参数
 *
 * @author
 * @date 2024-08-30 17:02:53
 * @since 1.0
 */
@Data
public class AddVenueInformationDTO {

	/**
     * 场馆类型
     */
    @JsonProperty("venueType")
    private String venueType;
	/**
     * 场馆名称
     */
    @JsonProperty("venueName")
    private String venueName;
	/**
     * 所属省编码
     */
    @JsonProperty("provinceCode")
    private String provinceCode;
	/**
     * 所属市编码
     */
    @JsonProperty("cityCode")
    private String cityCode;
	/**
     * 场馆地址
     */
    @JsonProperty("venueAddr")
    private String venueAddr;
	/**
     * 联系电话
     */
    @JsonProperty("contactNum")
    private String contactNum;
	/**
     * 场馆介绍
     */
    @JsonProperty("venueIntroduction")
    private String venueIntroduction;
	/**
     * 区域位置
     */
    @JsonProperty("regionalLocation")
    private String regionalLocation;
	/**
     * 统一信用代码
     */
    @JsonProperty("unifiedCreditCode")
    private String unifiedCreditCode;
	/**
     * 营业执照地址
     */
    @JsonProperty("businessLicenseAddr")
    private String businessLicenseAddr;
	/**
     * 用户id
     */
    @JsonProperty("userID")
    private Long userID;


}