package com.wlos.app.da.service.impl;


import com.wlos.app.da.mapper.SurveyTagMapper;
import com.wlos.app.model.SurveyTag;
import com.wlos.app.da.service.SurveyTagService;
import com.wlos.app.bl.AnalysisDataService;

import com.wlos.app.da.service.AutoincFieldService;
import com.wlos.app.enums.ModelAttributeEnum;
import com.wlos.app.utils.*;
import com.wlos.app.bo.SurveyTagBO; 
import com.wlos.app.vo.SurveyTagVO; 
import com.alibaba.fastjson.JSONObject;
import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.TypeReference;



import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.stereotype.Service;
import cn.hutool.core.util.IdUtil;
import com.wlos.app.exception.BusinessException;
import org.apache.commons.lang3.ObjectUtils;

import java.util.*;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;


import com.wlos.app.bo.where.DataQuery_RSqBWhereBO;
import com.wlos.app.bo.where.DataQuery_ufRXWhereBO;
import com.wlos.app.bo.where.DataQuery_eHuGWhereBO;
/**
 * 标签表 服务实现类
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:25 PM
 * @since v0.1
 */
@Service
public class SurveyTagServiceImpl extends ServiceImpl<SurveyTagMapper, SurveyTag> implements SurveyTagService {



    @Autowired
    private SurveyTagMapper surveyTagMapper;
    @Autowired
    private AnalysisDataService analysisDataService;
    @Autowired
    private AutoincFieldService autoincFieldService;


    
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /**
     * 根据id查询标签表
     *
     * @param id 主键id
     * @return 单条数据
     */
    @Override
    public SurveyTag queryById(String id) {
        LambdaQueryWrapper<SurveyTag> queryByPrimaryKey = Wrappers.<SurveyTag>lambdaQuery()
                .eq(SurveyTag::getId, id);
        return surveyTagMapper.selectOne(queryByPrimaryKey);
    }
  
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    @Override
    public Page<SurveyTag> page(Page<SurveyTag> page, SurveyTag condition) {
        return page(page, new QueryWrapper<>(condition));
    }

    /**
     * 创建标签表
     *
     * @param surveyTag 标签表载体
     * @return 实例主键
     */
    @Override
    public String insert(SurveyTag surveyTag) {

        //主键赋值
        String entityId = IdUtil.objectId();
        surveyTag.setId(entityId);





        log.info("starting insert params:{}",JSONObject.toJSONString(surveyTag));
        surveyTagMapper.insert(surveyTag);
        return surveyTag.getId();
    }

    /**
     * 更新标签表
     *
     * @param id 主键id
     * @param surveyTag 实例对象
     * @return 影响行数
     */
    @Override
    public Integer update(String id, SurveyTag surveyTag) {
        return surveyTagMapper.update(surveyTag, Wrappers.<SurveyTag>lambdaUpdate()
                .eq(SurveyTag::getId, id));
    }

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    @Override
    public Integer deleteById(String id) {
        return surveyTagMapper.deleteById(id);
    }
    
    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    @Override
    public int deleteByIds(List<String> list){
        return surveyTagMapper.deleteBatchIds(list);
    }    




  
    /**
     * 
     * 通用新增  标签表表 新增操作
     * @param surveyTagBo 新增参数 
     * @return 新增id
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public String insert(SurveyTagBO surveyTagBo) {

        //主键赋值
        String entityId = IdUtil.objectId();
        surveyTagBo.setId(entityId);







        SurveyTag surveyTag = BeanUtil.copyProperties(surveyTagBo,SurveyTag.class);
        //执行主表 标签表新增
        save(surveyTag);
        return surveyTag.getId();
    }


    




  
    /**
     * 流程-标签列表查询-数据查询-查询标签 标签表表 数据查询
     *
     * @param dataQuery_RSqBWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public List<SurveyTag> list(DataQuery_RSqBWhereBO dataQuery_RSqBWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_RSqBWhereBo));
        List<SurveyTag> res = surveyTagMapper.dataQuery_RSqB(dataQuery_RSqBWhereBo);


        return res;

    }

    




  
    /**
     * 流程-根据分类id查询分类名称-数据查询 标签表表 数据查询
     *
     * @param dataQuery_ufRXWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public SurveyTag selectOne(DataQuery_ufRXWhereBO dataQuery_ufRXWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_ufRXWhereBo));
        SurveyTag res = surveyTagMapper.dataQuery_ufRX(dataQuery_ufRXWhereBo);


        return res;

    }

    




  
    /**
     * 流程-根据父级id查询标签列表-数据查询-标签列表 标签表表 数据查询
     *
     * @param dataQuery_eHuGWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public List<SurveyTag> list(DataQuery_eHuGWhereBO dataQuery_eHuGWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_eHuGWhereBo));
        List<SurveyTag> res = surveyTagMapper.dataQuery_eHuG(dataQuery_eHuGWhereBo);


        return res;

    }

    
    static final class SurveyTagConstants{


     /***
	 * dataQuery_RSqB use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_RSQB_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_ufRX use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_UFRX_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_eHuG use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_EHUG_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};


}
}