package com.wlos.app.da.service.impl;


import com.wlos.app.da.mapper.SurveySignMapper;
import com.wlos.app.model.SurveySign;
import com.wlos.app.da.service.SurveySignService;
import com.wlos.app.bl.AnalysisDataService;

import com.wlos.app.da.service.AutoincFieldService;
import com.wlos.app.enums.ModelAttributeEnum;
import com.wlos.app.utils.*;
import com.wlos.app.bo.SurveySignBO; 
import com.wlos.app.vo.SurveySignVO; 
import com.alibaba.fastjson.JSONObject;
import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.TypeReference;



import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.stereotype.Service;
import cn.hutool.core.util.IdUtil;
import com.wlos.app.exception.BusinessException;
import org.apache.commons.lang3.ObjectUtils;

import java.util.*;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;


import com.wlos.app.bo.where.AddorupdsurveyplancheckindataModificationWhereBO;
import com.wlos.app.bo.where.DataQuery_WzkNWhereBO;
import com.wlos.app.bo.where.DataQuery_gUprWhereBO;
import com.wlos.app.bo.where.DataQuery_vyhDWhereBO;
/**
 * 勘查签到表 服务实现类
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:26 PM
 * @since v0.1
 */
@Service
public class SurveySignServiceImpl extends ServiceImpl<SurveySignMapper, SurveySign> implements SurveySignService {



    @Autowired
    private SurveySignMapper surveySignMapper;
    @Autowired
    private AnalysisDataService analysisDataService;
    @Autowired
    private AutoincFieldService autoincFieldService;


    
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /**
     * 根据id查询勘查签到表
     *
     * @param id 主键id
     * @return 单条数据
     */
    @Override
    public SurveySign queryById(String id) {
        LambdaQueryWrapper<SurveySign> queryByPrimaryKey = Wrappers.<SurveySign>lambdaQuery()
                .eq(SurveySign::getId, id);
        return surveySignMapper.selectOne(queryByPrimaryKey);
    }
  
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    @Override
    public Page<SurveySign> page(Page<SurveySign> page, SurveySign condition) {
        return page(page, new QueryWrapper<>(condition));
    }

    /**
     * 创建勘查签到表
     *
     * @param surveySign 勘查签到表载体
     * @return 实例主键
     */
    @Override
    public String insert(SurveySign surveySign) {

        //主键赋值
        String entityId = "";





        log.info("starting insert params:{}",JSONObject.toJSONString(surveySign));
        surveySignMapper.insert(surveySign);
        return surveySign.getId();
    }

    /**
     * 更新勘查签到表
     *
     * @param id 主键id
     * @param surveySign 实例对象
     * @return 影响行数
     */
    @Override
    public Integer update(String id, SurveySign surveySign) {
        return surveySignMapper.update(surveySign, Wrappers.<SurveySign>lambdaUpdate()
                .eq(SurveySign::getId, id));
    }

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    @Override
    public Integer deleteById(String id) {
        return surveySignMapper.deleteById(id);
    }
    
    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    @Override
    public int deleteByIds(List<String> list){
        return surveySignMapper.deleteBatchIds(list);
    }    




  
    /**
     * 
     * 通用新增  勘查签到表表 新增操作
     * @param surveySignBo 新增参数 
     * @return 新增id
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public String insert(SurveySignBO surveySignBo) {

        //主键赋值
        String entityId = "";







        SurveySign surveySign = BeanUtil.copyProperties(surveySignBo,SurveySign.class);
        //执行主表 勘查签到表新增
        save(surveySign);
        return surveySign.getId();
    }


    




  
    /**
     * 新增或更新踏勘计划签到-数据修改 勘查签到表表 数据修改
     *
     * @param surveySignBo 修改参数BO 
     * @param addorupdsurveyplancheckindataModificationWhereBo 修改参数BO 
     * @return 受影响行数
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public Integer update(SurveySignBO surveySignBo,AddorupdsurveyplancheckindataModificationWhereBO addorupdsurveyplancheckindataModificationWhereBo) {

        Integer effectLines=0;
        //主表修改    
        effectLines = surveySignMapper.addorupdsurveyplancheckindataModification(surveySignBo,addorupdsurveyplancheckindataModificationWhereBo);
        return effectLines;      
    }   


    




  
    /**
     * 流程-新增或更新踏勘计划签到-数据查询 勘查签到表表 数据查询
     *
     * @param dataQuery_WzkNWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public List<SurveySign> list(DataQuery_WzkNWhereBO dataQuery_WzkNWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_WzkNWhereBo));
        List<SurveySign> res = surveySignMapper.dataQuery_WzkN(dataQuery_WzkNWhereBo);


        return res;

    }

    




  
    /**
     * 流程-踏勘是否签到-数据查询 勘查签到表表 数据查询
     *
     * @param dataQuery_gUprWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public List<SurveySign> list(DataQuery_gUprWhereBO dataQuery_gUprWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_gUprWhereBo));
        List<SurveySign> res = surveySignMapper.dataQuery_gUpr(dataQuery_gUprWhereBo);


        return res;

    }

    




  
    /**
     * 流程-根据计划id查询计划信息-数据查询-签到信息 勘查签到表表 数据查询
     *
     * @param dataQuery_vyhDWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public SurveySign selectOne(DataQuery_vyhDWhereBO dataQuery_vyhDWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_vyhDWhereBo));
        SurveySign res = surveySignMapper.dataQuery_vyhD(dataQuery_vyhDWhereBo);


        return res;

    }

    
    static final class SurveySignConstants{






     /***
	 * dataQuery_WzkN use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_WZKN_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_gUpr use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_GUPR_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_vyhD use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_VYHD_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};


}
}