package com.wlos.app.da.service.impl;


import com.wlos.app.da.mapper.SurveyProjectMapper;
import com.wlos.app.model.SurveyProject;
import com.wlos.app.da.service.SurveyProjectService;
import com.wlos.app.bl.AnalysisDataService;

import com.wlos.app.da.service.AutoincFieldService;
import com.wlos.app.enums.ModelAttributeEnum;
import com.wlos.app.utils.*;
import com.wlos.app.bo.SurveyProjectBO; 
import com.wlos.app.vo.SurveyProjectVO; 
import com.alibaba.fastjson.JSONObject;
import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.TypeReference;



import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.stereotype.Service;
import cn.hutool.core.util.IdUtil;
import com.wlos.app.exception.BusinessException;
import org.apache.commons.lang3.ObjectUtils;

import java.util.*;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;


import com.wlos.app.bo.where.DelcorrespondingrecordsbasedonquestionnairequestioniddataDeletionQuestionnaireQuestionsWhereBO;
import com.wlos.app.bo.where.AddsupplementaryquestionnairequestionrecordsdataModificationWhereBO;
/**
 * 勘查项目 服务实现类
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:26 PM
 * @since v0.1
 */
@Service
public class SurveyProjectServiceImpl extends ServiceImpl<SurveyProjectMapper, SurveyProject> implements SurveyProjectService {



    @Autowired
    private SurveyProjectMapper surveyProjectMapper;
    @Autowired
    private AnalysisDataService analysisDataService;
    @Autowired
    private AutoincFieldService autoincFieldService;


    
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /**
     * 根据id查询勘查项目
     *
     * @param id 主键id
     * @return 单条数据
     */
    @Override
    public SurveyProject queryById(String id) {
        LambdaQueryWrapper<SurveyProject> queryByPrimaryKey = Wrappers.<SurveyProject>lambdaQuery()
                .eq(SurveyProject::getId, id);
        return surveyProjectMapper.selectOne(queryByPrimaryKey);
    }
  
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    @Override
    public Page<SurveyProject> page(Page<SurveyProject> page, SurveyProject condition) {
        return page(page, new QueryWrapper<>(condition));
    }

    /**
     * 创建勘查项目
     *
     * @param surveyProject 勘查项目载体
     * @return 实例主键
     */
    @Override
    public String insert(SurveyProject surveyProject) {

        //主键赋值
        String entityId = "";





        log.info("starting insert params:{}",JSONObject.toJSONString(surveyProject));
        surveyProjectMapper.insert(surveyProject);
        return surveyProject.getId();
    }

    /**
     * 更新勘查项目
     *
     * @param id 主键id
     * @param surveyProject 实例对象
     * @return 影响行数
     */
    @Override
    public Integer update(String id, SurveyProject surveyProject) {
        return surveyProjectMapper.update(surveyProject, Wrappers.<SurveyProject>lambdaUpdate()
                .eq(SurveyProject::getId, id));
    }

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    @Override
    public Integer deleteById(String id) {
        return surveyProjectMapper.deleteById(id);
    }
    
    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    @Override
    public int deleteByIds(List<String> list){
        return surveyProjectMapper.deleteBatchIds(list);
    }    




  
    /**
     * 
     * 通用新增  勘查项目表 新增操作
     * @param surveyProjectBo 新增参数 
     * @return 新增id
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public String insert(SurveyProjectBO surveyProjectBo) {

        //主键赋值
        String entityId = "";







        SurveyProject surveyProject = BeanUtil.copyProperties(surveyProjectBo,SurveyProject.class);
        //执行主表 勘查项目新增
        save(surveyProject);
        return surveyProject.getId();
    }


    




  
    /**
     * 根据问卷问题id删除对应记录-数据删除-问卷题目 勘查项目表 数据删除
     *
     * @param delcorrespondingrecordsbasedonquestionnairequestioniddataDeletionQuestionnaireQuestionsWhereBo 删除参数BO 
     * @return 受影响行数
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public Integer delete(DelcorrespondingrecordsbasedonquestionnairequestioniddataDeletionQuestionnaireQuestionsWhereBO delcorrespondingrecordsbasedonquestionnairequestioniddataDeletionQuestionnaireQuestionsWhereBo) {
        return  surveyProjectMapper.delcorrespondingrecordsbasedonquestionnairequestioniddataDeletionQuestionnaireQuestions(delcorrespondingrecordsbasedonquestionnairequestioniddataDeletionQuestionnaireQuestionsWhereBo);
    } 

    




  
    /**
     * 新增问卷补充问题记录-数据修改 勘查项目表 数据修改
     *
     * @param surveyProjectBo 修改参数BO 
     * @param addsupplementaryquestionnairequestionrecordsdataModificationWhereBo 修改参数BO 
     * @return 受影响行数
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public Integer update(SurveyProjectBO surveyProjectBo,AddsupplementaryquestionnairequestionrecordsdataModificationWhereBO addsupplementaryquestionnairequestionrecordsdataModificationWhereBo) {

        Integer effectLines=0;
        //主表修改    
        effectLines = surveyProjectMapper.addsupplementaryquestionnairequestionrecordsdataModification(surveyProjectBo,addsupplementaryquestionnairequestionrecordsdataModificationWhereBo);
        return effectLines;      
    }   


    
    static final class SurveyProjectConstants{








}
}