package com.wlos.app.da.service.impl;


import com.wlos.app.da.mapper.SurveyPlanMapper;
import com.wlos.app.model.SurveyPlan;
import com.wlos.app.da.service.SurveyPlanService;
import com.wlos.app.bl.AnalysisDataService;

import com.wlos.app.da.service.AutoincFieldService;
import com.wlos.app.enums.ModelAttributeEnum;
import com.wlos.app.utils.*;
import com.wlos.app.bo.SurveyPlanBO; 
import com.wlos.app.vo.SurveyPlanVO; 
import com.alibaba.fastjson.JSONObject;
import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.TypeReference;



import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.stereotype.Service;
import cn.hutool.core.util.IdUtil;
import com.wlos.app.exception.BusinessException;
import org.apache.commons.lang3.ObjectUtils;

import java.util.*;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;


import com.wlos.app.bo.where.DataQuery_BsWDWhereBO;
import com.wlos.app.bo.where.DataQuery_bAiCWhereBO;
import com.wlos.app.bo.where.UpdplansignaturedataModificationSignatureOfSurveyPersonnelWhereBO;
import com.wlos.app.bo.where.UpdplansignaturedataModificationSignatureOfTheOrganizerWhereBO;
import com.wlos.app.bo.where.ModifyplandataModificationPlanWhereBO;
import com.wlos.app.bo.where.GenquestionnairedataModificationPlanStsWhereBO;
import com.wlos.app.bo.where.DataQuery_aiPC_GqBoWhereBO;
import com.wlos.app.bo.where.DataQuery_zloFWhereBO;
import com.wlos.app.bo.where.DataQuery_okFgWhereBO;
import com.wlos.app.bo.where.DataQuery_sOdzWhereBO;
import com.wlos.app.bo.where.DataQuery_CncCWhereBO;
import com.wlos.app.bo.where.DataQuery_AuHNWhereBO;
import com.wlos.app.bo.DataqueryAuhnBO;
import com.wlos.app.bo.where.DataQuery_rMQqWhereBO;
import com.wlos.app.bo.DataqueryRmqqBO;
import com.wlos.app.bo.where.DataQuery_BcEjWhereBO;
import com.wlos.app.bo.DataqueryBcejBO;
import com.wlos.app.bo.where.DataQuery_aiPCWhereBO;
import com.wlos.app.bo.DataqueryAipcBO;
import com.wlos.app.bo.where.DataQuery_gsTWWhereBO;
import com.wlos.app.bo.DataqueryGstwBO;
/**
 * 勘查计划 服务实现类
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:28 PM
 * @since v0.1
 */
@Service
public class SurveyPlanServiceImpl extends ServiceImpl<SurveyPlanMapper, SurveyPlan> implements SurveyPlanService {



    @Autowired
    private SurveyPlanMapper surveyPlanMapper;
    @Autowired
    private AnalysisDataService analysisDataService;
    @Autowired
    private AutoincFieldService autoincFieldService;


    
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /**
     * 根据id查询勘查计划
     *
     * @param id 主键id
     * @return 单条数据
     */
    @Override
    public SurveyPlan queryById(String id) {
        LambdaQueryWrapper<SurveyPlan> queryByPrimaryKey = Wrappers.<SurveyPlan>lambdaQuery()
                .eq(SurveyPlan::getId, id);
        return surveyPlanMapper.selectOne(queryByPrimaryKey);
    }
  
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    @Override
    public Page<SurveyPlan> page(Page<SurveyPlan> page, SurveyPlan condition) {
        return page(page, new QueryWrapper<>(condition));
    }

    /**
     * 创建勘查计划
     *
     * @param surveyPlan 勘查计划载体
     * @return 实例主键
     */
    @Override
    public String insert(SurveyPlan surveyPlan) {

        //主键赋值
        String entityId = "";





        log.info("starting insert params:{}",JSONObject.toJSONString(surveyPlan));
        surveyPlanMapper.insert(surveyPlan);
        return surveyPlan.getId();
    }

    /**
     * 更新勘查计划
     *
     * @param id 主键id
     * @param surveyPlan 实例对象
     * @return 影响行数
     */
    @Override
    public Integer update(String id, SurveyPlan surveyPlan) {
        return surveyPlanMapper.update(surveyPlan, Wrappers.<SurveyPlan>lambdaUpdate()
                .eq(SurveyPlan::getId, id));
    }

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    @Override
    public Integer deleteById(String id) {
        return surveyPlanMapper.deleteById(id);
    }
    
    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    @Override
    public int deleteByIds(List<String> list){
        return surveyPlanMapper.deleteBatchIds(list);
    }    




  
    /**
     * 
     * 通用新增  勘查计划表 新增操作
     * @param surveyPlanBo 新增参数 
     * @return 新增id
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public String insert(SurveyPlanBO surveyPlanBo) {

        //主键赋值
        String entityId = "";







        SurveyPlan surveyPlan = BeanUtil.copyProperties(surveyPlanBo,SurveyPlan.class);
        //执行主表 勘查计划新增
        save(surveyPlan);
        return surveyPlan.getId();
    }


    




  
    /**
     * 流程-根据问卷id查询计划-数据查询 勘查计划表 数据查询
     *
     * @param dataQuery_BsWDWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public SurveyPlan selectOne(DataQuery_BsWDWhereBO dataQuery_BsWDWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_BsWDWhereBo));
        SurveyPlan res = surveyPlanMapper.dataQuery_BsWD(dataQuery_BsWDWhereBo);


        return res;

    }

    




  
    /**
     * 流程-根据任务id查询踏勘计划次数-数据查询 勘查计划表 数据查询
     *
     * @param dataQuery_bAiCWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public List<SurveyPlan> list(DataQuery_bAiCWhereBO dataQuery_bAiCWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_bAiCWhereBo));
        List<SurveyPlan> res = surveyPlanMapper.dataQuery_bAiC(dataQuery_bAiCWhereBo);


        return res;

    }

    




  
    /**
     * 更新计划签名-数据修改-踏勘人员签名 勘查计划表 数据修改
     *
     * @param surveyPlanBo 修改参数BO 
     * @param updplansignaturedataModificationSignatureOfSurveyPersonnelWhereBo 修改参数BO 
     * @return 受影响行数
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public Integer update(SurveyPlanBO surveyPlanBo,UpdplansignaturedataModificationSignatureOfSurveyPersonnelWhereBO updplansignaturedataModificationSignatureOfSurveyPersonnelWhereBo) {

        Integer effectLines=0;
        //主表修改    
        effectLines = surveyPlanMapper.updplansignaturedataModificationSignatureOfSurveyPersonnel(surveyPlanBo,updplansignaturedataModificationSignatureOfSurveyPersonnelWhereBo);
        return effectLines;      
    }   


    




  
    /**
     * 更新计划签名-数据修改-承办方签名 勘查计划表 数据修改
     *
     * @param surveyPlanBo 修改参数BO 
     * @param updplansignaturedataModificationSignatureOfTheOrganizerWhereBo 修改参数BO 
     * @return 受影响行数
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public Integer update(SurveyPlanBO surveyPlanBo,UpdplansignaturedataModificationSignatureOfTheOrganizerWhereBO updplansignaturedataModificationSignatureOfTheOrganizerWhereBo) {

        Integer effectLines=0;
        //主表修改    
        effectLines = surveyPlanMapper.updplansignaturedataModificationSignatureOfTheOrganizer(surveyPlanBo,updplansignaturedataModificationSignatureOfTheOrganizerWhereBo);
        return effectLines;      
    }   


    




  
    /**
     * 修改计划-数据修改-计划 勘查计划表 数据修改
     *
     * @param surveyPlanBo 修改参数BO 
     * @param modifyplandataModificationPlanWhereBo 修改参数BO 
     * @return 受影响行数
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public Integer update(SurveyPlanBO surveyPlanBo,ModifyplandataModificationPlanWhereBO modifyplandataModificationPlanWhereBo) {

        Integer effectLines=0;
        //主表修改    
        effectLines = surveyPlanMapper.modifyplandataModificationPlan(surveyPlanBo,modifyplandataModificationPlanWhereBo);
        return effectLines;      
    }   


    




  
    /**
     * 生成问卷-数据修改-计划状态 勘查计划表 数据修改
     *
     * @param surveyPlanBo 修改参数BO 
     * @param genquestionnairedataModificationPlanStsWhereBo 修改参数BO 
     * @return 受影响行数
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public Integer update(SurveyPlanBO surveyPlanBo,GenquestionnairedataModificationPlanStsWhereBO genquestionnairedataModificationPlanStsWhereBo) {

        Integer effectLines=0;
        //主表修改    
        effectLines = surveyPlanMapper.genquestionnairedataModificationPlanSts(surveyPlanBo,genquestionnairedataModificationPlanStsWhereBo);
        return effectLines;      
    }   


    




  
    /**
     * 流程-根据计划id查询计划-数据查询 勘查计划表 数据查询
     *
     * @param dataQuery_aiPC_GqBoWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public SurveyPlan selectOne(DataQuery_aiPC_GqBoWhereBO dataQuery_aiPC_GqBoWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_aiPC_GqBoWhereBo));
        SurveyPlan res = surveyPlanMapper.dataQuery_aiPC_GqBo(dataQuery_aiPC_GqBoWhereBo);


        return res;

    }

    




  
    /**
     * 流程-根据计划id和问题类型查询问题列表-数据查询-计划 勘查计划表 数据查询
     *
     * @param dataQuery_zloFWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public SurveyPlan selectOne(DataQuery_zloFWhereBO dataQuery_zloFWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_zloFWhereBo));
        SurveyPlan res = surveyPlanMapper.dataQuery_zloF(dataQuery_zloFWhereBo);


        return res;

    }

    




  
    /**
     * 流程-根据任务id查询最大计划次数-数据查询-倒序查询次数 勘查计划表 数据查询
     *
     * @param dataQuery_okFgWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public List<SurveyPlan> list(DataQuery_okFgWhereBO dataQuery_okFgWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_okFgWhereBo));
        List<SurveyPlan> res = surveyPlanMapper.dataQuery_okFg(dataQuery_okFgWhereBo);


        return res;

    }

    




  
    /**
     * 流程-根据任务id和次数查询勘查计划-数据查询 勘查计划表 数据查询
     *
     * @param dataQuery_sOdzWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public List<SurveyPlan> list(DataQuery_sOdzWhereBO dataQuery_sOdzWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_sOdzWhereBo));
        List<SurveyPlan> res = surveyPlanMapper.dataQuery_sOdz(dataQuery_sOdzWhereBo);


        return res;

    }

    




  
    /**
     * 流程-根据任务id查询次数列表-数据查询 勘查计划表 数据查询
     *
     * @param dataQuery_CncCWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public List<SurveyPlan> list(DataQuery_CncCWhereBO dataQuery_CncCWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_CncCWhereBo));
        List<SurveyPlan> res = surveyPlanMapper.dataQuery_CncC(dataQuery_CncCWhereBo);


        return res;

    }

    




  
    /**
     * 流程-更新踏勘结果-报告生成未开发-数据查询-未作答题目记录 勘查计划表 数据查询
     *
     * @param dataQuery_AuHNWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public List<DataqueryAuhnBO> list(DataQuery_AuHNWhereBO dataQuery_AuHNWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_AuHNWhereBo));
        List<DataqueryAuhnBO> res = surveyPlanMapper.dataQuery_AuHN(dataQuery_AuHNWhereBo);


        return res;

    }

    




  
    /**
     * 流程-问卷设计列表查询-数据查询-计划列表 勘查计划表 数据查询
     *
     * @param dataQuery_rMQqWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public List<DataqueryRmqqBO> list(DataQuery_rMQqWhereBO dataQuery_rMQqWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_rMQqWhereBo));
        List<DataqueryRmqqBO> res = surveyPlanMapper.dataQuery_rMQq(dataQuery_rMQqWhereBo);


        return res;

    }

    




  
    /**
     * 流程-根据年月份查询未完成的任务列表-数据查询 勘查计划表 数据查询
     *
     * @param dataQuery_BcEjWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public List<DataqueryBcejBO> list(DataQuery_BcEjWhereBO dataQuery_BcEjWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_BcEjWhereBo));
        List<DataqueryBcejBO> res = surveyPlanMapper.dataQuery_BcEj(dataQuery_BcEjWhereBo);


        return res;

    }

    




  
    /**
     * 流程-根据计划id查询计划详情-数据查询 勘查计划表 数据查询
     *
     * @param dataQuery_aiPCWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public DataqueryAipcBO selectOne(DataQuery_aiPCWhereBO dataQuery_aiPCWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_aiPCWhereBo));
        DataqueryAipcBO res = surveyPlanMapper.dataQuery_aiPC(dataQuery_aiPCWhereBo);


        return res;

    }

    




  
    /**
     * 流程-根据计划id查询计划信息-数据查询-踏勘计划 勘查计划表 数据查询
     *
     * @param dataQuery_gsTWWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public DataqueryGstwBO selectOne(DataQuery_gsTWWhereBO dataQuery_gsTWWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_gsTWWhereBo));
        DataqueryGstwBO res = surveyPlanMapper.dataQuery_gsTW(dataQuery_gsTWWhereBo);


        return res;

    }

    
    static final class SurveyPlanConstants{


     /***
	 * dataQuery_BsWD use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_BSWD_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_bAiC use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_BAIC_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




















     /***
	 * dataQuery_aiPC_GqBo use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_AIPC_GQBO_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_zloF use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_ZLOF_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_okFg use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_OKFG_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_sOdz use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_SODZ_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_CncC use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_CNCC_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_AuHN use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_AUHN_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_rMQq use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_RMQQ_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_BcEj use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_BCEJ_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_aiPC use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_AIPC_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_gsTW use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_GSTW_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};


}
}