package com.wlos.app.da.service.impl;


import com.wlos.app.da.mapper.SurveyPhotoMapper;
import com.wlos.app.model.SurveyPhoto;
import com.wlos.app.da.service.SurveyPhotoService;
import com.wlos.app.bl.AnalysisDataService;

import com.wlos.app.da.service.AutoincFieldService;
import com.wlos.app.enums.ModelAttributeEnum;
import com.wlos.app.utils.*;
import com.wlos.app.bo.SurveyPhotoBO; 
import com.wlos.app.vo.SurveyPhotoVO; 
import com.alibaba.fastjson.JSONObject;
import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.TypeReference;



import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.stereotype.Service;
import cn.hutool.core.util.IdUtil;
import com.wlos.app.exception.BusinessException;
import org.apache.commons.lang3.ObjectUtils;

import java.util.*;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;


import com.wlos.app.bo.where.DelattachmentsdataDeletionWhereBO;
import com.wlos.app.bo.where.DataQuery_TVACWhereBO;
/**
 * 查勘现场照片 服务实现类
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:26 PM
 * @since v0.1
 */
@Service
public class SurveyPhotoServiceImpl extends ServiceImpl<SurveyPhotoMapper, SurveyPhoto> implements SurveyPhotoService {



    @Autowired
    private SurveyPhotoMapper surveyPhotoMapper;
    @Autowired
    private AnalysisDataService analysisDataService;
    @Autowired
    private AutoincFieldService autoincFieldService;


    
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /**
     * 根据id查询查勘现场照片
     *
     * @param id 主键id
     * @return 单条数据
     */
    @Override
    public SurveyPhoto queryById(String id) {
        LambdaQueryWrapper<SurveyPhoto> queryByPrimaryKey = Wrappers.<SurveyPhoto>lambdaQuery()
                .eq(SurveyPhoto::getId, id);
        return surveyPhotoMapper.selectOne(queryByPrimaryKey);
    }
  
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    @Override
    public Page<SurveyPhoto> page(Page<SurveyPhoto> page, SurveyPhoto condition) {
        return page(page, new QueryWrapper<>(condition));
    }

    /**
     * 创建查勘现场照片
     *
     * @param surveyPhoto 查勘现场照片载体
     * @return 实例主键
     */
    @Override
    public String insert(SurveyPhoto surveyPhoto) {

        //主键赋值
        String entityId = "";





        log.info("starting insert params:{}",JSONObject.toJSONString(surveyPhoto));
        surveyPhotoMapper.insert(surveyPhoto);
        return surveyPhoto.getId();
    }

    /**
     * 更新查勘现场照片
     *
     * @param id 主键id
     * @param surveyPhoto 实例对象
     * @return 影响行数
     */
    @Override
    public Integer update(String id, SurveyPhoto surveyPhoto) {
        return surveyPhotoMapper.update(surveyPhoto, Wrappers.<SurveyPhoto>lambdaUpdate()
                .eq(SurveyPhoto::getId, id));
    }

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    @Override
    public Integer deleteById(String id) {
        return surveyPhotoMapper.deleteById(id);
    }
    
    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    @Override
    public int deleteByIds(List<String> list){
        return surveyPhotoMapper.deleteBatchIds(list);
    }    




  
    /**
     * 
     * 通用新增  查勘现场照片表 新增操作
     * @param surveyPhotoBo 新增参数 
     * @return 新增id
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public String insert(SurveyPhotoBO surveyPhotoBo) {

        //主键赋值
        String entityId = "";







        SurveyPhoto surveyPhoto = BeanUtil.copyProperties(surveyPhotoBo,SurveyPhoto.class);
        //执行主表 查勘现场照片新增
        save(surveyPhoto);
        return surveyPhoto.getId();
    }


    




  
    /**
     * 删除附件-数据删除 查勘现场照片表 数据删除
     *
     * @param delattachmentsdataDeletionWhereBo 删除参数BO 
     * @return 受影响行数
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public Integer delete(DelattachmentsdataDeletionWhereBO delattachmentsdataDeletionWhereBo) {
        return  surveyPhotoMapper.delattachmentsdataDeletion(delattachmentsdataDeletionWhereBo);
    } 

    




  
    /**
     * 流程-根据回答id查询附件列表-数据查询 查勘现场照片表 数据查询
     *
     * @param dataQuery_TVACWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public List<SurveyPhoto> list(DataQuery_TVACWhereBO dataQuery_TVACWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_TVACWhereBo));
        List<SurveyPhoto> res = surveyPhotoMapper.dataQuery_TVAC(dataQuery_TVACWhereBo);


        return res;

    }

    
    static final class SurveyPhotoConstants{






     /***
	 * dataQuery_TVAC use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_TVAC_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};


}
}