package com.wlos.app.da.service.impl;


import com.wlos.app.da.mapper.SurveyInfoMapper;
import com.wlos.app.model.SurveyInfo;
import com.wlos.app.da.service.SurveyInfoService;
import com.wlos.app.bl.AnalysisDataService;

import com.wlos.app.da.service.AutoincFieldService;
import com.wlos.app.enums.ModelAttributeEnum;
import com.wlos.app.utils.*;
import com.wlos.app.bo.SurveyInfoBO; 
import com.wlos.app.vo.SurveyInfoVO; 
import com.alibaba.fastjson.JSONObject;
import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.TypeReference;



import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.stereotype.Service;
import cn.hutool.core.util.IdUtil;
import com.wlos.app.exception.BusinessException;
import org.apache.commons.lang3.ObjectUtils;

import java.util.*;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;


import com.wlos.app.bo.where.UpdquestionanswerinformationdataModificationWhereBO;
import com.wlos.app.bo.DataqueryOouxBO;
import com.wlos.app.bo.where.DelcorrespondingrecordsbasedonquestionnairequestioniddelRecordOfQuestionAnswerTblWhereBO;
import com.wlos.app.bo.where.DataQuery_kBPxWhereBO;
import com.wlos.app.bo.DataqueryKbpxBO;
import com.wlos.app.bo.where.DataQuery_VLaLWhereBO;
import com.wlos.app.bo.DataqueryVlalBO;
import com.wlos.app.bo.where.DataQuery_rLQSWhereBO;
import com.wlos.app.bo.where.DataQuery_gXAHWhereBO;
import com.wlos.app.bo.DataqueryGxahBO;
import com.wlos.app.bo.where.DataQuery_YsjPWhereBO;
import com.wlos.app.bo.DataqueryYsjpBO;
/**
 * 查勘现场具体问题及反馈详情 服务实现类
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:26 PM
 * @since v0.1
 */
@Service
public class SurveyInfoServiceImpl extends ServiceImpl<SurveyInfoMapper, SurveyInfo> implements SurveyInfoService {



    @Autowired
    private SurveyInfoMapper surveyInfoMapper;
    @Autowired
    private AnalysisDataService analysisDataService;
    @Autowired
    private AutoincFieldService autoincFieldService;


    
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /**
     * 根据id查询查勘现场具体问题及反馈详情
     *
     * @param id 主键id
     * @return 单条数据
     */
    @Override
    public SurveyInfo queryById(String id) {
        LambdaQueryWrapper<SurveyInfo> queryByPrimaryKey = Wrappers.<SurveyInfo>lambdaQuery()
                .eq(SurveyInfo::getId, id);
        return surveyInfoMapper.selectOne(queryByPrimaryKey);
    }
  
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    @Override
    public Page<SurveyInfo> page(Page<SurveyInfo> page, SurveyInfo condition) {
        return page(page, new QueryWrapper<>(condition));
    }

    /**
     * 创建查勘现场具体问题及反馈详情
     *
     * @param surveyInfo 查勘现场具体问题及反馈详情载体
     * @return 实例主键
     */
    @Override
    public String insert(SurveyInfo surveyInfo) {

        //主键赋值
        String entityId = "";





        log.info("starting insert params:{}",JSONObject.toJSONString(surveyInfo));
        surveyInfoMapper.insert(surveyInfo);
        return surveyInfo.getId();
    }

    /**
     * 更新查勘现场具体问题及反馈详情
     *
     * @param id 主键id
     * @param surveyInfo 实例对象
     * @return 影响行数
     */
    @Override
    public Integer update(String id, SurveyInfo surveyInfo) {
        return surveyInfoMapper.update(surveyInfo, Wrappers.<SurveyInfo>lambdaUpdate()
                .eq(SurveyInfo::getId, id));
    }

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    @Override
    public Integer deleteById(String id) {
        return surveyInfoMapper.deleteById(id);
    }
    
    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    @Override
    public int deleteByIds(List<String> list){
        return surveyInfoMapper.deleteBatchIds(list);
    }    




  
    /**
     * 
     * 通用新增  查勘现场具体问题及反馈详情表 新增操作
     * @param surveyInfoBo 新增参数 
     * @return 新增id
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public String insert(SurveyInfoBO surveyInfoBo) {

        //主键赋值
        String entityId = "";







        SurveyInfo surveyInfo = BeanUtil.copyProperties(surveyInfoBo,SurveyInfo.class);
        //执行主表 查勘现场具体问题及反馈详情新增
        save(surveyInfo);
        return surveyInfo.getId();
    }


    




  
    /**
     * 更新问题回答信息-数据修改 查勘现场具体问题及反馈详情表 数据修改
     *
     * @param surveyInfoBo 修改参数BO 
     * @param updquestionanswerinformationdataModificationWhereBo 修改参数BO 
     * @return 受影响行数
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public Integer update(SurveyInfoBO surveyInfoBo,UpdquestionanswerinformationdataModificationWhereBO updquestionanswerinformationdataModificationWhereBo) {

        Integer effectLines=0;
        //主表修改    
        effectLines = surveyInfoMapper.updquestionanswerinformationdataModification(surveyInfoBo,updquestionanswerinformationdataModificationWhereBo);
        return effectLines;      
    }   


    




  
    /**
     * 流程-根据问卷id查询所有问题列表-数据查询 查勘现场具体问题及反馈详情表 数据查询
     *
     * @return 查询结果集
     */
    @Override
    public List<DataqueryOouxBO> dataQuery_OouX() {
        List<DataqueryOouxBO> res = surveyInfoMapper.dataQuery_OouX();


        return res;

    }

    




  
    /**
     * 根据问卷问题id删除对应记录-问题回答表记录删除 查勘现场具体问题及反馈详情表 数据删除
     *
     * @param delcorrespondingrecordsbasedonquestionnairequestioniddelRecordOfQuestionAnswerTblWhereBo 删除参数BO 
     * @return 受影响行数
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public Integer delete(DelcorrespondingrecordsbasedonquestionnairequestioniddelRecordOfQuestionAnswerTblWhereBO delcorrespondingrecordsbasedonquestionnairequestioniddelRecordOfQuestionAnswerTblWhereBo) {
        return  surveyInfoMapper.delcorrespondingrecordsbasedonquestionnairequestioniddelRecordOfQuestionAnswerTbl(delcorrespondingrecordsbasedonquestionnairequestioniddelRecordOfQuestionAnswerTblWhereBo);
    } 

    




  
    /**
     * 流程-根据回答id查询问题信息-数据查询-问题详情 查勘现场具体问题及反馈详情表 数据查询
     *
     * @param dataQuery_kBPxWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public DataqueryKbpxBO selectOne(DataQuery_kBPxWhereBO dataQuery_kBPxWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_kBPxWhereBo));
        DataqueryKbpxBO res = surveyInfoMapper.dataQuery_kBPx(dataQuery_kBPxWhereBo);


        return res;

    }

    




  
    /**
     * 流程-下一题-数据查询-查之后的题目 查勘现场具体问题及反馈详情表 数据查询
     *
     * @param dataQuery_VLaLWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public List<DataqueryVlalBO> list(DataQuery_VLaLWhereBO dataQuery_VLaLWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_VLaLWhereBo));
        List<DataqueryVlalBO> res = surveyInfoMapper.dataQuery_VLaL(dataQuery_VLaLWhereBo);


        return res;

    }

    




  
    /**
     * 流程-生成问卷-问卷的问题列表 查勘现场具体问题及反馈详情表 数据查询
     *
     * @param dataQuery_rLQSWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public List<SurveyInfo> list(DataQuery_rLQSWhereBO dataQuery_rLQSWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_rLQSWhereBo));
        List<SurveyInfo> res = surveyInfoMapper.dataQuery_rLQS(dataQuery_rLQSWhereBo);


        return res;

    }

    




  
    /**
     * 流程-根据计划id和问题类型查询问题列表-数据查询-问题 查勘现场具体问题及反馈详情表 数据查询
     *
     * @param dataQuery_gXAHWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public List<DataqueryGxahBO> list(DataQuery_gXAHWhereBO dataQuery_gXAHWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_gXAHWhereBo));
        List<DataqueryGxahBO> res = surveyInfoMapper.dataQuery_gXAH(dataQuery_gXAHWhereBo);


        return res;

    }

    




  
    /**
     * 流程-根据计划id和问题类型查询问题列表-数据查询-已答问题 查勘现场具体问题及反馈详情表 数据查询
     *
     * @param dataQuery_YsjPWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public List<DataqueryYsjpBO> list(DataQuery_YsjPWhereBO dataQuery_YsjPWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_YsjPWhereBo));
        List<DataqueryYsjpBO> res = surveyInfoMapper.dataQuery_YsjP(dataQuery_YsjPWhereBo);


        return res;

    }

    
    static final class SurveyInfoConstants{






     /***
	 * dataQuery_OouX use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_OOUX_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};








     /***
	 * dataQuery_kBPx use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_KBPX_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_VLaL use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_VLAL_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_rLQS use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_RLQS_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_gXAH use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_GXAH_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_YsjP use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_YSJP_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};


}
}