package com.wlos.app.da.service.impl;


import com.wlos.app.da.mapper.SurveyFeedbackMapper;
import com.wlos.app.model.SurveyFeedback;
import com.wlos.app.da.service.SurveyFeedbackService;
import com.wlos.app.bl.AnalysisDataService;

import com.wlos.app.da.service.AutoincFieldService;
import com.wlos.app.enums.ModelAttributeEnum;
import com.wlos.app.utils.*;
import com.wlos.app.bo.SurveyFeedbackBO; 
import com.wlos.app.vo.SurveyFeedbackVO; 
import com.alibaba.fastjson.JSONObject;
import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.TypeReference;



import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.stereotype.Service;
import cn.hutool.core.util.IdUtil;
import com.wlos.app.exception.BusinessException;
import org.apache.commons.lang3.ObjectUtils;

import java.util.*;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;


import com.wlos.app.bo.where.ModifyplandataModificationSurveyFeedbackWhereBO;
import com.wlos.app.bo.where.UpdsurveyresultsreportgenerationundevelopeddataModificationSurveyFeedbackStsUpdWhereBO;
/**
 * 查勘反馈 服务实现类
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:26 PM
 * @since v0.1
 */
@Service
public class SurveyFeedbackServiceImpl extends ServiceImpl<SurveyFeedbackMapper, SurveyFeedback> implements SurveyFeedbackService {



    @Autowired
    private SurveyFeedbackMapper surveyFeedbackMapper;
    @Autowired
    private AnalysisDataService analysisDataService;
    @Autowired
    private AutoincFieldService autoincFieldService;


    
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /**
     * 根据id查询查勘反馈
     *
     * @param id 主键id
     * @return 单条数据
     */
    @Override
    public SurveyFeedback queryById(String id) {
        LambdaQueryWrapper<SurveyFeedback> queryByPrimaryKey = Wrappers.<SurveyFeedback>lambdaQuery()
                .eq(SurveyFeedback::getId, id);
        return surveyFeedbackMapper.selectOne(queryByPrimaryKey);
    }
  
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    @Override
    public Page<SurveyFeedback> page(Page<SurveyFeedback> page, SurveyFeedback condition) {
        return page(page, new QueryWrapper<>(condition));
    }

    /**
     * 创建查勘反馈
     *
     * @param surveyFeedback 查勘反馈载体
     * @return 实例主键
     */
    @Override
    public String insert(SurveyFeedback surveyFeedback) {

        //主键赋值
        String entityId = "";





        log.info("starting insert params:{}",JSONObject.toJSONString(surveyFeedback));
        surveyFeedbackMapper.insert(surveyFeedback);
        return surveyFeedback.getId();
    }

    /**
     * 更新查勘反馈
     *
     * @param id 主键id
     * @param surveyFeedback 实例对象
     * @return 影响行数
     */
    @Override
    public Integer update(String id, SurveyFeedback surveyFeedback) {
        return surveyFeedbackMapper.update(surveyFeedback, Wrappers.<SurveyFeedback>lambdaUpdate()
                .eq(SurveyFeedback::getId, id));
    }

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    @Override
    public Integer deleteById(String id) {
        return surveyFeedbackMapper.deleteById(id);
    }
    
    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    @Override
    public int deleteByIds(List<String> list){
        return surveyFeedbackMapper.deleteBatchIds(list);
    }    




  
    /**
     * 
     * 通用新增  查勘反馈表 新增操作
     * @param surveyFeedbackBo 新增参数 
     * @return 新增id
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public String insert(SurveyFeedbackBO surveyFeedbackBo) {

        //主键赋值
        String entityId = "";







        SurveyFeedback surveyFeedback = BeanUtil.copyProperties(surveyFeedbackBo,SurveyFeedback.class);
        //执行主表 查勘反馈新增
        save(surveyFeedback);
        return surveyFeedback.getId();
    }


    




  
    /**
     * 修改计划-数据修改-查勘反馈 查勘反馈表 数据修改
     *
     * @param surveyFeedbackBo 修改参数BO 
     * @param modifyplandataModificationSurveyFeedbackWhereBo 修改参数BO 
     * @return 受影响行数
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public Integer update(SurveyFeedbackBO surveyFeedbackBo,ModifyplandataModificationSurveyFeedbackWhereBO modifyplandataModificationSurveyFeedbackWhereBo) {

        Integer effectLines=0;
        //主表修改    
        effectLines = surveyFeedbackMapper.modifyplandataModificationSurveyFeedback(surveyFeedbackBo,modifyplandataModificationSurveyFeedbackWhereBo);
        return effectLines;      
    }   


    




  
    /**
     * 更新踏勘结果-报告生成未开发-数据修改-查勘反馈状态更新 查勘反馈表 数据修改
     *
     * @param surveyFeedbackBo 修改参数BO 
     * @param updsurveyresultsreportgenerationundevelopeddataModificationSurveyFeedbackStsUpdWhereBo 修改参数BO 
     * @return 受影响行数
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public Integer update(SurveyFeedbackBO surveyFeedbackBo,UpdsurveyresultsreportgenerationundevelopeddataModificationSurveyFeedbackStsUpdWhereBO updsurveyresultsreportgenerationundevelopeddataModificationSurveyFeedbackStsUpdWhereBo) {

        Integer effectLines=0;
        //主表修改    
        effectLines = surveyFeedbackMapper.updsurveyresultsreportgenerationundevelopeddataModificationSurveyFeedbackStsUpd(surveyFeedbackBo,updsurveyresultsreportgenerationundevelopeddataModificationSurveyFeedbackStsUpdWhereBo);
        return effectLines;      
    }   


    
    static final class SurveyFeedbackConstants{








}
}