package com.wlos.app.da.service;


import com.wlos.app.model.VenueInformation;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.wlos.app.bo.VenueInformationBO; 
import com.wlos.app.vo.VenueInformationVO; 
import java.util.*;
import com.baomidou.mybatisplus.extension.service.IService;


import com.wlos.app.bo.where.DataQuery_WxdwWhereBO;
import com.wlos.app.bo.where.DataQuery_NIUaWhereBO;
import com.wlos.app.bo.where.ModifyvenueinformationdataModificationWhereBO;
import com.wlos.app.bo.where.DataQuery_HwicWhereBO;/**
 * 场馆信息 服务接口
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:35 PM
 * @since v0.1
 */
public interface VenueInformationService extends IService<VenueInformation> {

    /**
     * 根据id查询场馆信息
     *
     * @param id 主键id
     * @return 单条数据
     */
    VenueInformation queryById(String id);
    
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    Page<VenueInformation> page(Page<VenueInformation> page, VenueInformation condition);


    /**
     * 创建场馆信息
     *
     * @param venueInformation 场馆信息载体
     * @return 场馆信息 新增实体主键
     */
    String insert(VenueInformation venueInformation);
    

    /**
     * 更新场馆信息
     *
     * @param id 主键id
     * @param venueInformation 实例对象
     * @return 影响行数
     */
    Integer update(String id, VenueInformation venueInformation);


    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    Integer deleteById(String id);
    

    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    int deleteByIds(List<String> list);


    
    /**
     * 通用新增
     * 
     * @param venueInformationBo 新增参数 
     * @return 新增id
     */
    String insert(VenueInformationBO venueInformationBo);



    
    /**
     * 流程-根据场馆id查询场馆信息-数据查询
     * 
     * @param dataQuery_WxdwWhereBo 查询参数BO 
     * @return 查询结果集
     */
    VenueInformation selectOne(DataQuery_WxdwWhereBO dataQuery_WxdwWhereBo);


    
    /**
     * 流程-根据区域查询场馆列表-数据查询
     * 
     * @param dataQuery_NIUaWhereBo 查询参数BO 
     * @return 查询结果集
     */
    List<VenueInformation> list(DataQuery_NIUaWhereBO dataQuery_NIUaWhereBo);


    
    /**
     * 修改场馆信息-数据修改
     * 
     * @param venueInformationBo 修改参数BO 
     * @param modifyvenueinformationdataModificationWhereBo 修改参数BO 
     * @return 受影响行数
     */
    Integer update(VenueInformationBO venueInformationBo,ModifyvenueinformationdataModificationWhereBO modifyvenueinformationdataModificationWhereBo);



    
    /**
     * 流程-修改场馆信息-数据查询
     * 
     * @param dataQuery_HwicWhereBo 查询参数BO 
     * @return 查询结果集
     */
    VenueInformation selectOne(DataQuery_HwicWhereBO dataQuery_HwicWhereBo);

}