package com.wlos.app.da.service;


import com.wlos.app.model.SurveyTag;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.wlos.app.bo.SurveyTagBO; 
import com.wlos.app.vo.SurveyTagVO; 
import java.util.*;
import com.baomidou.mybatisplus.extension.service.IService;


import com.wlos.app.bo.where.DataQuery_RSqBWhereBO;
import com.wlos.app.bo.where.DataQuery_ufRXWhereBO;
import com.wlos.app.bo.where.DataQuery_eHuGWhereBO;/**
 * 标签表 服务接口
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:25 PM
 * @since v0.1
 */
public interface SurveyTagService extends IService<SurveyTag> {

    /**
     * 根据id查询标签表
     *
     * @param id 主键id
     * @return 单条数据
     */
    SurveyTag queryById(String id);
    
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    Page<SurveyTag> page(Page<SurveyTag> page, SurveyTag condition);


    /**
     * 创建标签表
     *
     * @param surveyTag 标签表载体
     * @return 标签表 新增实体主键
     */
    String insert(SurveyTag surveyTag);
    

    /**
     * 更新标签表
     *
     * @param id 主键id
     * @param surveyTag 实例对象
     * @return 影响行数
     */
    Integer update(String id, SurveyTag surveyTag);


    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    Integer deleteById(String id);
    

    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    int deleteByIds(List<String> list);


    
    /**
     * 通用新增
     * 
     * @param surveyTagBo 新增参数 
     * @return 新增id
     */
    String insert(SurveyTagBO surveyTagBo);



    
    /**
     * 流程-标签列表查询-数据查询-查询标签
     * 
     * @param dataQuery_RSqBWhereBo 查询参数BO 
     * @return 查询结果集
     */
    List<SurveyTag> list(DataQuery_RSqBWhereBO dataQuery_RSqBWhereBo);


    
    /**
     * 流程-根据分类id查询分类名称-数据查询
     * 
     * @param dataQuery_ufRXWhereBo 查询参数BO 
     * @return 查询结果集
     */
    SurveyTag selectOne(DataQuery_ufRXWhereBO dataQuery_ufRXWhereBo);


    
    /**
     * 流程-根据父级id查询标签列表-数据查询-标签列表
     * 
     * @param dataQuery_eHuGWhereBo 查询参数BO 
     * @return 查询结果集
     */
    List<SurveyTag> list(DataQuery_eHuGWhereBO dataQuery_eHuGWhereBo);

}