package com.wlos.app.da.service;


import com.wlos.app.model.SurveyQuestionnaire;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.wlos.app.bo.SurveyQuestionnaireBO; 
import com.wlos.app.vo.SurveyQuestionnaireVO; 
import java.util.*;
import com.baomidou.mybatisplus.extension.service.IService;


import com.wlos.app.bo.where.ModifyplandataModificationQuestionnaireWhereBO;
import com.wlos.app.bo.where.GenquestionnairedataModificationQuestionnaireStsWhereBO;
import com.wlos.app.bo.where.DataQuery_dqCrWhereBO;
import com.wlos.app.bo.where.DataQuery_iKAYWhereBO;
import com.wlos.app.bo.where.DataQuery_yeFLWhereBO;
import com.wlos.app.bo.where.UpdsurveyresultsreportgenerationundevelopeddataModificationQuestionnaireStsUpdWhereBO;/**
 * 问卷 服务接口
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:27 PM
 * @since v0.1
 */
public interface SurveyQuestionnaireService extends IService<SurveyQuestionnaire> {

    /**
     * 根据id查询问卷
     *
     * @param id 主键id
     * @return 单条数据
     */
    SurveyQuestionnaire queryById(String id);
    
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    Page<SurveyQuestionnaire> page(Page<SurveyQuestionnaire> page, SurveyQuestionnaire condition);


    /**
     * 创建问卷
     *
     * @param surveyQuestionnaire 问卷载体
     * @return 问卷 新增实体主键
     */
    String insert(SurveyQuestionnaire surveyQuestionnaire);
    

    /**
     * 更新问卷
     *
     * @param id 主键id
     * @param surveyQuestionnaire 实例对象
     * @return 影响行数
     */
    Integer update(String id, SurveyQuestionnaire surveyQuestionnaire);


    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    Integer deleteById(String id);
    

    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    int deleteByIds(List<String> list);


    
    /**
     * 通用新增
     * 
     * @param surveyQuestionnaireBo 新增参数 
     * @return 新增id
     */
    String insert(SurveyQuestionnaireBO surveyQuestionnaireBo);



    
    /**
     * 修改计划-数据修改-问卷
     * 
     * @param surveyQuestionnaireBo 修改参数BO 
     * @param modifyplandataModificationQuestionnaireWhereBo 修改参数BO 
     * @return 受影响行数
     */
    Integer update(SurveyQuestionnaireBO surveyQuestionnaireBo,ModifyplandataModificationQuestionnaireWhereBO modifyplandataModificationQuestionnaireWhereBo);



    
    /**
     * 生成问卷-数据修改-问卷状态
     * 
     * @param surveyQuestionnaireBo 修改参数BO 
     * @param genquestionnairedataModificationQuestionnaireStsWhereBo 修改参数BO 
     * @return 受影响行数
     */
    Integer update(SurveyQuestionnaireBO surveyQuestionnaireBo,GenquestionnairedataModificationQuestionnaireStsWhereBO genquestionnairedataModificationQuestionnaireStsWhereBo);



    
    /**
     * 流程-生成问卷-数据查询-问卷信息
     * 
     * @param dataQuery_dqCrWhereBo 查询参数BO 
     * @return 查询结果集
     */
    SurveyQuestionnaire selectOne(DataQuery_dqCrWhereBO dataQuery_dqCrWhereBo);


    
    /**
     * 流程-根据计划id和问题类型查询问题列表-数据查询-问卷
     * 
     * @param dataQuery_iKAYWhereBo 查询参数BO 
     * @return 查询结果集
     */
    SurveyQuestionnaire selectOne(DataQuery_iKAYWhereBO dataQuery_iKAYWhereBo);


    
    /**
     * 流程-新增问卷补充问题记录-数据查询-获取问卷信息
     * 
     * @param dataQuery_yeFLWhereBo 查询参数BO 
     * @return 查询结果集
     */
    SurveyQuestionnaire selectOne(DataQuery_yeFLWhereBO dataQuery_yeFLWhereBo);


    
    /**
     * 更新踏勘结果-报告生成未开发-数据修改-问卷状态更新
     * 
     * @param surveyQuestionnaireBo 修改参数BO 
     * @param updsurveyresultsreportgenerationundevelopeddataModificationQuestionnaireStsUpdWhereBo 修改参数BO 
     * @return 受影响行数
     */
    Integer update(SurveyQuestionnaireBO surveyQuestionnaireBo,UpdsurveyresultsreportgenerationundevelopeddataModificationQuestionnaireStsUpdWhereBO updsurveyresultsreportgenerationundevelopeddataModificationQuestionnaireStsUpdWhereBo);


}