package com.wlos.app.da.service;


import com.wlos.app.model.SurveyPlan;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.wlos.app.bo.SurveyPlanBO; 
import com.wlos.app.vo.SurveyPlanVO; 
import java.util.*;
import com.baomidou.mybatisplus.extension.service.IService;


import com.wlos.app.bo.where.DataQuery_BsWDWhereBO;
import com.wlos.app.bo.where.DataQuery_bAiCWhereBO;
import com.wlos.app.bo.where.UpdplansignaturedataModificationSignatureOfSurveyPersonnelWhereBO;
import com.wlos.app.bo.where.UpdplansignaturedataModificationSignatureOfTheOrganizerWhereBO;
import com.wlos.app.bo.where.ModifyplandataModificationPlanWhereBO;
import com.wlos.app.bo.where.GenquestionnairedataModificationPlanStsWhereBO;
import com.wlos.app.bo.where.DataQuery_aiPC_GqBoWhereBO;
import com.wlos.app.bo.where.DataQuery_zloFWhereBO;
import com.wlos.app.bo.where.DataQuery_okFgWhereBO;
import com.wlos.app.bo.where.DataQuery_sOdzWhereBO;
import com.wlos.app.bo.where.DataQuery_CncCWhereBO;
import com.wlos.app.bo.where.DataQuery_AuHNWhereBO;
import com.wlos.app.bo.DataqueryAuhnBO;
import com.wlos.app.bo.where.DataQuery_rMQqWhereBO;
import com.wlos.app.bo.DataqueryRmqqBO;
import com.wlos.app.bo.where.DataQuery_BcEjWhereBO;
import com.wlos.app.bo.DataqueryBcejBO;
import com.wlos.app.bo.where.DataQuery_aiPCWhereBO;
import com.wlos.app.bo.DataqueryAipcBO;
import com.wlos.app.bo.where.DataQuery_gsTWWhereBO;
import com.wlos.app.bo.DataqueryGstwBO;/**
 * 勘查计划 服务接口
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:28 PM
 * @since v0.1
 */
public interface SurveyPlanService extends IService<SurveyPlan> {

    /**
     * 根据id查询勘查计划
     *
     * @param id 主键id
     * @return 单条数据
     */
    SurveyPlan queryById(String id);
    
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    Page<SurveyPlan> page(Page<SurveyPlan> page, SurveyPlan condition);


    /**
     * 创建勘查计划
     *
     * @param surveyPlan 勘查计划载体
     * @return 勘查计划 新增实体主键
     */
    String insert(SurveyPlan surveyPlan);
    

    /**
     * 更新勘查计划
     *
     * @param id 主键id
     * @param surveyPlan 实例对象
     * @return 影响行数
     */
    Integer update(String id, SurveyPlan surveyPlan);


    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    Integer deleteById(String id);
    

    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    int deleteByIds(List<String> list);


    
    /**
     * 通用新增
     * 
     * @param surveyPlanBo 新增参数 
     * @return 新增id
     */
    String insert(SurveyPlanBO surveyPlanBo);



    
    /**
     * 流程-根据问卷id查询计划-数据查询
     * 
     * @param dataQuery_BsWDWhereBo 查询参数BO 
     * @return 查询结果集
     */
    SurveyPlan selectOne(DataQuery_BsWDWhereBO dataQuery_BsWDWhereBo);


    
    /**
     * 流程-根据任务id查询踏勘计划次数-数据查询
     * 
     * @param dataQuery_bAiCWhereBo 查询参数BO 
     * @return 查询结果集
     */
    List<SurveyPlan> list(DataQuery_bAiCWhereBO dataQuery_bAiCWhereBo);


    
    /**
     * 更新计划签名-数据修改-踏勘人员签名
     * 
     * @param surveyPlanBo 修改参数BO 
     * @param updplansignaturedataModificationSignatureOfSurveyPersonnelWhereBo 修改参数BO 
     * @return 受影响行数
     */
    Integer update(SurveyPlanBO surveyPlanBo,UpdplansignaturedataModificationSignatureOfSurveyPersonnelWhereBO updplansignaturedataModificationSignatureOfSurveyPersonnelWhereBo);



    
    /**
     * 更新计划签名-数据修改-承办方签名
     * 
     * @param surveyPlanBo 修改参数BO 
     * @param updplansignaturedataModificationSignatureOfTheOrganizerWhereBo 修改参数BO 
     * @return 受影响行数
     */
    Integer update(SurveyPlanBO surveyPlanBo,UpdplansignaturedataModificationSignatureOfTheOrganizerWhereBO updplansignaturedataModificationSignatureOfTheOrganizerWhereBo);



    
    /**
     * 修改计划-数据修改-计划
     * 
     * @param surveyPlanBo 修改参数BO 
     * @param modifyplandataModificationPlanWhereBo 修改参数BO 
     * @return 受影响行数
     */
    Integer update(SurveyPlanBO surveyPlanBo,ModifyplandataModificationPlanWhereBO modifyplandataModificationPlanWhereBo);



    
    /**
     * 生成问卷-数据修改-计划状态
     * 
     * @param surveyPlanBo 修改参数BO 
     * @param genquestionnairedataModificationPlanStsWhereBo 修改参数BO 
     * @return 受影响行数
     */
    Integer update(SurveyPlanBO surveyPlanBo,GenquestionnairedataModificationPlanStsWhereBO genquestionnairedataModificationPlanStsWhereBo);



    
    /**
     * 流程-根据计划id查询计划-数据查询
     * 
     * @param dataQuery_aiPC_GqBoWhereBo 查询参数BO 
     * @return 查询结果集
     */
    SurveyPlan selectOne(DataQuery_aiPC_GqBoWhereBO dataQuery_aiPC_GqBoWhereBo);


    
    /**
     * 流程-根据计划id和问题类型查询问题列表-数据查询-计划
     * 
     * @param dataQuery_zloFWhereBo 查询参数BO 
     * @return 查询结果集
     */
    SurveyPlan selectOne(DataQuery_zloFWhereBO dataQuery_zloFWhereBo);


    
    /**
     * 流程-根据任务id查询最大计划次数-数据查询-倒序查询次数
     * 
     * @param dataQuery_okFgWhereBo 查询参数BO 
     * @return 查询结果集
     */
    List<SurveyPlan> list(DataQuery_okFgWhereBO dataQuery_okFgWhereBo);


    
    /**
     * 流程-根据任务id和次数查询勘查计划-数据查询
     * 
     * @param dataQuery_sOdzWhereBo 查询参数BO 
     * @return 查询结果集
     */
    List<SurveyPlan> list(DataQuery_sOdzWhereBO dataQuery_sOdzWhereBo);


    
    /**
     * 流程-根据任务id查询次数列表-数据查询
     * 
     * @param dataQuery_CncCWhereBo 查询参数BO 
     * @return 查询结果集
     */
    List<SurveyPlan> list(DataQuery_CncCWhereBO dataQuery_CncCWhereBo);


    
    /**
     * 流程-更新踏勘结果-报告生成未开发-数据查询-未作答题目记录
     * 
     * @param dataQuery_AuHNWhereBo 查询参数BO 
     * @return 查询结果集
     */
    List<DataqueryAuhnBO> list(DataQuery_AuHNWhereBO dataQuery_AuHNWhereBo);


    
    /**
     * 流程-问卷设计列表查询-数据查询-计划列表
     * 
     * @param dataQuery_rMQqWhereBo 查询参数BO 
     * @return 查询结果集
     */
    List<DataqueryRmqqBO> list(DataQuery_rMQqWhereBO dataQuery_rMQqWhereBo);


    
    /**
     * 流程-根据年月份查询未完成的任务列表-数据查询
     * 
     * @param dataQuery_BcEjWhereBo 查询参数BO 
     * @return 查询结果集
     */
    List<DataqueryBcejBO> list(DataQuery_BcEjWhereBO dataQuery_BcEjWhereBo);


    
    /**
     * 流程-根据计划id查询计划详情-数据查询
     * 
     * @param dataQuery_aiPCWhereBo 查询参数BO 
     * @return 查询结果集
     */
    DataqueryAipcBO selectOne(DataQuery_aiPCWhereBO dataQuery_aiPCWhereBo);


    
    /**
     * 流程-根据计划id查询计划信息-数据查询-踏勘计划
     * 
     * @param dataQuery_gsTWWhereBo 查询参数BO 
     * @return 查询结果集
     */
    DataqueryGstwBO selectOne(DataQuery_gsTWWhereBO dataQuery_gsTWWhereBo);

}