package com.wlos.app.da.service;


import com.wlos.app.model.SurveyPhoto;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.wlos.app.bo.SurveyPhotoBO; 
import com.wlos.app.vo.SurveyPhotoVO; 
import java.util.*;
import com.baomidou.mybatisplus.extension.service.IService;


import com.wlos.app.bo.where.DelattachmentsdataDeletionWhereBO;
import com.wlos.app.bo.where.DataQuery_TVACWhereBO;/**
 * 查勘现场照片 服务接口
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:26 PM
 * @since v0.1
 */
public interface SurveyPhotoService extends IService<SurveyPhoto> {

    /**
     * 根据id查询查勘现场照片
     *
     * @param id 主键id
     * @return 单条数据
     */
    SurveyPhoto queryById(String id);
    
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    Page<SurveyPhoto> page(Page<SurveyPhoto> page, SurveyPhoto condition);


    /**
     * 创建查勘现场照片
     *
     * @param surveyPhoto 查勘现场照片载体
     * @return 查勘现场照片 新增实体主键
     */
    String insert(SurveyPhoto surveyPhoto);
    

    /**
     * 更新查勘现场照片
     *
     * @param id 主键id
     * @param surveyPhoto 实例对象
     * @return 影响行数
     */
    Integer update(String id, SurveyPhoto surveyPhoto);


    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    Integer deleteById(String id);
    

    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    int deleteByIds(List<String> list);


    
    /**
     * 通用新增
     * 
     * @param surveyPhotoBo 新增参数 
     * @return 新增id
     */
    String insert(SurveyPhotoBO surveyPhotoBo);



        
    /**
     * 删除附件-数据删除
     * 
     * @param delattachmentsdataDeletionWhereBo 删除参数BO 
     * @return 受影响行数
     */
    Integer delete(DelattachmentsdataDeletionWhereBO delattachmentsdataDeletionWhereBo);



    
    /**
     * 流程-根据回答id查询附件列表-数据查询
     * 
     * @param dataQuery_TVACWhereBo 查询参数BO 
     * @return 查询结果集
     */
    List<SurveyPhoto> list(DataQuery_TVACWhereBO dataQuery_TVACWhereBo);

}