package com.wlos.app.da.service;


import com.wlos.app.model.SurveyInfo;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.wlos.app.bo.SurveyInfoBO; 
import com.wlos.app.vo.SurveyInfoVO; 
import java.util.*;
import com.baomidou.mybatisplus.extension.service.IService;


import com.wlos.app.bo.where.UpdquestionanswerinformationdataModificationWhereBO;
import com.wlos.app.bo.DataqueryOouxBO;
import com.wlos.app.bo.where.DelcorrespondingrecordsbasedonquestionnairequestioniddelRecordOfQuestionAnswerTblWhereBO;
import com.wlos.app.bo.where.DataQuery_kBPxWhereBO;
import com.wlos.app.bo.DataqueryKbpxBO;
import com.wlos.app.bo.where.DataQuery_VLaLWhereBO;
import com.wlos.app.bo.DataqueryVlalBO;
import com.wlos.app.bo.where.DataQuery_rLQSWhereBO;
import com.wlos.app.bo.where.DataQuery_gXAHWhereBO;
import com.wlos.app.bo.DataqueryGxahBO;
import com.wlos.app.bo.where.DataQuery_YsjPWhereBO;
import com.wlos.app.bo.DataqueryYsjpBO;/**
 * 查勘现场具体问题及反馈详情 服务接口
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:26 PM
 * @since v0.1
 */
public interface SurveyInfoService extends IService<SurveyInfo> {

    /**
     * 根据id查询查勘现场具体问题及反馈详情
     *
     * @param id 主键id
     * @return 单条数据
     */
    SurveyInfo queryById(String id);
    
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    Page<SurveyInfo> page(Page<SurveyInfo> page, SurveyInfo condition);


    /**
     * 创建查勘现场具体问题及反馈详情
     *
     * @param surveyInfo 查勘现场具体问题及反馈详情载体
     * @return 查勘现场具体问题及反馈详情 新增实体主键
     */
    String insert(SurveyInfo surveyInfo);
    

    /**
     * 更新查勘现场具体问题及反馈详情
     *
     * @param id 主键id
     * @param surveyInfo 实例对象
     * @return 影响行数
     */
    Integer update(String id, SurveyInfo surveyInfo);


    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    Integer deleteById(String id);
    

    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    int deleteByIds(List<String> list);


    
    /**
     * 通用新增
     * 
     * @param surveyInfoBo 新增参数 
     * @return 新增id
     */
    String insert(SurveyInfoBO surveyInfoBo);



    
    /**
     * 更新问题回答信息-数据修改
     * 
     * @param surveyInfoBo 修改参数BO 
     * @param updquestionanswerinformationdataModificationWhereBo 修改参数BO 
     * @return 受影响行数
     */
    Integer update(SurveyInfoBO surveyInfoBo,UpdquestionanswerinformationdataModificationWhereBO updquestionanswerinformationdataModificationWhereBo);



    
    /**
     * 流程-根据问卷id查询所有问题列表-数据查询
     * 
     * @return 查询结果集
     */
    List<DataqueryOouxBO> dataQuery_OouX();


        
    /**
     * 根据问卷问题id删除对应记录-问题回答表记录删除
     * 
     * @param delcorrespondingrecordsbasedonquestionnairequestioniddelRecordOfQuestionAnswerTblWhereBo 删除参数BO 
     * @return 受影响行数
     */
    Integer delete(DelcorrespondingrecordsbasedonquestionnairequestioniddelRecordOfQuestionAnswerTblWhereBO delcorrespondingrecordsbasedonquestionnairequestioniddelRecordOfQuestionAnswerTblWhereBo);



    
    /**
     * 流程-根据回答id查询问题信息-数据查询-问题详情
     * 
     * @param dataQuery_kBPxWhereBo 查询参数BO 
     * @return 查询结果集
     */
    DataqueryKbpxBO selectOne(DataQuery_kBPxWhereBO dataQuery_kBPxWhereBo);


    
    /**
     * 流程-下一题-数据查询-查之后的题目
     * 
     * @param dataQuery_VLaLWhereBo 查询参数BO 
     * @return 查询结果集
     */
    List<DataqueryVlalBO> list(DataQuery_VLaLWhereBO dataQuery_VLaLWhereBo);


    
    /**
     * 流程-生成问卷-问卷的问题列表
     * 
     * @param dataQuery_rLQSWhereBo 查询参数BO 
     * @return 查询结果集
     */
    List<SurveyInfo> list(DataQuery_rLQSWhereBO dataQuery_rLQSWhereBo);


    
    /**
     * 流程-根据计划id和问题类型查询问题列表-数据查询-问题
     * 
     * @param dataQuery_gXAHWhereBo 查询参数BO 
     * @return 查询结果集
     */
    List<DataqueryGxahBO> list(DataQuery_gXAHWhereBO dataQuery_gXAHWhereBo);


    
    /**
     * 流程-根据计划id和问题类型查询问题列表-数据查询-已答问题
     * 
     * @param dataQuery_YsjPWhereBo 查询参数BO 
     * @return 查询结果集
     */
    List<DataqueryYsjpBO> list(DataQuery_YsjPWhereBO dataQuery_YsjPWhereBo);

}