package com.wlos.app.da.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.wlos.app.enums.AttributeTypeEnums;
import com.wlos.app.enums.ModelAttributeEnum;
import com.wlos.app.enums.ModelDataTypeEnum;
import com.wlos.app.utils.Constants;
import com.wlos.app.exception.BusinessException;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.*;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;


@Service
public class ProcessQueryHandlerService {

    protected static final Logger logger = LoggerFactory.getLogger(ProcessQueryHandlerService.class);
    private static Map<Integer, String> dateForamtMap = new HashMap<>();
    static {
        dateForamtMap.put(1, "yyyy");
        dateForamtMap.put(2, "yyyy-MM");
        dateForamtMap.put(3, "yyyy-MM-dd");
        dateForamtMap.put(4, "yyyy-MM-dd HH:mm:ss");
        dateForamtMap.put(5, "yyyy-dd");
        dateForamtMap.put(6, "yyyy/MM");
        dateForamtMap.put(7, "yyyy/MM/dd");
        dateForamtMap.put(8, "yyyy/dd");
        dateForamtMap.put(9, "HH:mm:ss");
        dateForamtMap.put(10, "HH:mm");
        dateForamtMap.put(11, "yyyy-MM-dd HH:mm");
        dateForamtMap.put(12, "yyyy/MM/dd HH:mm:ss");
        dateForamtMap.put(13, "yyyy/MM/dd HH:mm");
    }

    /**
     * flow version v1
     * @param resultList
     * @param relationKeys
     * @param primaryKey
     * @return
     */
    public List<Map<String, Object>> queryProcessHandle(List<Map<String, Object>> resultList,MultiValueMap<String, String> relationKeys, String primaryKey) {
        List<List<Map<String, Object>>> result = new ArrayList<>();
        //将list里数据，按字段名,mapKey进行拆分
        Map<String, Integer> subIndexMap = new HashMap<>();
        for (Map<String, Object> itemdata : resultList) {
            Map<String, Object> primaryMap = new HashMap<>();
            HashMap<String, HashMap<String, Object>> subMaps = new HashMap<>();

            relationKeys.forEach((key, value) -> {
                HashMap<String, Object> subItemMap = new HashMap<>();
                subMaps.put(key, subItemMap);
            });

            List<Map<String, Object>> tempList = new ArrayList<>();
            itemdata.forEach((key, value) -> {
                AtomicBoolean isPresent = new AtomicBoolean(false);
                relationKeys.forEach((key1, value1) -> {
                    if (key.startsWith(key1)) {
                        isPresent.set(true);
                        String subkey = key.substring(2);
                        HashMap<String, Object> subItemMap = subMaps.get(key1);
                        subItemMap.put(subkey, value);
                    }

                });
                if (!isPresent.get()) {
                    primaryMap.put(key, value);
                }

            });
            tempList.add(primaryMap);
            AtomicInteger initIndex = new AtomicInteger(0);
            relationKeys.forEach((key, value) -> {
                initIndex.getAndIncrement();
                subIndexMap.put(key, initIndex.get());
                tempList.add(subMaps.get(key));
            });
            result.add(tempList);
        }
        List<Integer> alreadyTakenIndex = new ArrayList<>();
        List<Map<String, Object>> finalResultList = new ArrayList<>();
        //将同组数据进行切片聚合处理
        for (int i = 0; i < result.size(); i++) {
            if (alreadyTakenIndex.contains(i)) {
                continue;
            }
            List<Map<String, Object>> maps = result.get(i);
            Map<String, Object> objectMap = maps.get(0);


            for (Map.Entry<String, List<String>> stringStringEntry : relationKeys.entrySet()) {
                Set<Map> data1 = new HashSet<>();
                String key = stringStringEntry.getKey();
                String relationKey = stringStringEntry.getValue().get(0);
                String relationTablePrimaryKey = stringStringEntry.getValue().get(1);

                Integer integer = subIndexMap.get(key);
                Map<String, Object> objectData = maps.get(integer);
                Map<String, Object> stringMapHashMap = new HashMap<>();
                stringMapHashMap.put(Constants.COLUMNS, objectData);
                stringMapHashMap.put(Constants.UUID, objectData.get("" + relationTablePrimaryKey));
                data1.add(stringMapHashMap);
                Object uuid = objectMap.get(primaryKey);
                int next = i + 1;
                while (next < result.size()) {
                    List<Map<String, Object>> maps1 = result.get(next);
                    Map<String, Object> stringObjectMap = maps1.get(0);

                    int finalNext = next;

                    Map<String, Object> stringObjectMap1 = maps1.get(integer);
                    if (uuid.equals(stringObjectMap.get(primaryKey))) {
                        alreadyTakenIndex.add(finalNext);
                        Map<String, Object> stringMapHashMap1 = new HashMap<>();
                        stringMapHashMap1.put(Constants.COLUMNS, stringObjectMap1);
                        stringMapHashMap1.put(Constants.UUID, stringObjectMap1.get("" + relationTablePrimaryKey));
                        data1.add(stringMapHashMap1);
                    }
                    next++;
                }
                objectMap.put(relationKey, data1);
            }
            finalResultList.add(objectMap);
        }
        return finalResultList;
    }

    /**
     * flow version v2
     * @param resultList
     * @param modelUuid
     * @param relationKeys
     * @param primaryKey
     * @return
     */
    public List<Map<String, Object>> queryProcessHandleV2(List<Map<String, Object>> resultList, String modelUuid, MultiValueMap<String, String> relationKeys, String primaryKey) {
        //=================================================================方案一
        List<List<Map<String, Object>>> result = new ArrayList<>();
        //将list里数据，按字段名,mapKey进行拆分
        Map<String, Integer> subIndexMap = new HashMap<>();
        for (Map<String, Object> itemdata : resultList) {
            Map<String, Object> primaryMap = new HashMap<>();
            HashMap<String, HashMap<String, Object>> subMaps = new HashMap<>();

            relationKeys.forEach((key, value) -> {
                HashMap<String, Object> subItemMap = new HashMap<>();
                subMaps.put(key, subItemMap);
            });

            List<Map<String, Object>> tempList = new ArrayList<>();
            itemdata.forEach((key, value) -> {
                AtomicBoolean isPresent = new AtomicBoolean(false);
                relationKeys.forEach((key1, value1) -> {
                    if (key.startsWith(key1)) {
                        isPresent.set(true);
                        String subkey = key.substring(2);
                        HashMap<String, Object> subItemMap = subMaps.get(key1);
                        subItemMap.put(subkey, value);
                    }

                });
                if (!isPresent.get()) {
                    primaryMap.put(key, value);
                }

            });
            tempList.add(primaryMap);
            AtomicInteger initIndex = new AtomicInteger(0);
            relationKeys.forEach((key, value) -> {
                initIndex.getAndIncrement();
                subIndexMap.put(key, initIndex.get());
                tempList.add(subMaps.get(key));
            });
            result.add(tempList);
        }
        List<Integer> alreadyTakenIndex = new ArrayList<>();
        List<Map<String, Object>> finalResultList = new ArrayList<>();

        List<ModelAttributeEnum.Attribute> attributes = ModelAttributeEnum.getAttribute(modelUuid);

        //将同组数据进行切片聚合处理
        for (int i = 0; i < result.size(); i++) {
            if (alreadyTakenIndex.contains(i)) {
                continue;
            }
            List<Map<String, Object>> maps = result.get(i);
            Map<String, Object> objectMap = maps.get(0);


            for (Map.Entry<String, List<String>> stringStringEntry : relationKeys.entrySet()) {
                Set data1 = new HashSet();
                Map<String, Object> relationData = new HashMap<>();

                String key = stringStringEntry.getKey();
                String relationKey = stringStringEntry.getValue().get(0);
                String relationTablePrimaryKey = stringStringEntry.getValue().get(1);

                ModelAttributeEnum.Attribute attribute = attributes.stream().filter(a -> a.enName().equals(relationKey)).findFirst().orElse(null);
                if (Objects.isNull(attribute)) {
                    attribute = attributes.stream()
                            .filter(a -> a.enName().equals(relationTablePrimaryKey))
                            .findFirst().orElseThrow(() -> new BusinessException("relationKey不存在"));
                }

                Integer integer = subIndexMap.get(key);
                Map<String, Object> objectData = maps.get(integer);
                String relationTablePrimaryValue = "";
                String type = stringStringEntry.getValue().get(2);
                String primaryMultiple = Optional.ofNullable(attribute.extData()).map(Object::toString).orElse("0");
                if(Objects.equals(type, "1")){
                    relationTablePrimaryValue =(String) objectData.get(relationTablePrimaryKey);
                    data1.add(relationTablePrimaryValue);
                }else {
                    data1.add(objectData);
                }

                if(Objects.equals(1, primaryMultiple)){
                    relationData = objectData;
                }
                Object uuid = objectMap.get(primaryKey);
                int next = i + 1;
                while (next < result.size()) {
                    List<Map<String, Object>> maps1 = result.get(next);
                    Map<String, Object> stringObjectMap = maps1.get(0);

                    int finalNext = next;

                    Map<String, Object> stringObjectMap1 = maps1.get(integer);
                    if (uuid.equals(stringObjectMap.get(primaryKey))) {
                        alreadyTakenIndex.add(finalNext);
                        if(Objects.equals(type, "1")){
                            relationTablePrimaryValue =(String) stringObjectMap1.get(relationTablePrimaryKey);
                            data1.add(relationTablePrimaryValue);
                        }else {
                            data1.add(stringObjectMap1);
                        }
                        if(Objects.equals(1, primaryMultiple)){
                            relationData = stringObjectMap1;
                        }
                    }

                    next++;
                }
                if(Objects.equals(1, primaryMultiple)){
                    objectMap.put(relationKey, relationData);
                }else {
                    objectMap.put(relationKey, data1);

                }
            }
            finalResultList.add(objectMap);

        }
        return finalResultList;
    }

    /**
     * 数据转换
     * @param resultData
     * @return
     */
    public List<Map<String, Object>> convertDataStructure(List<Map<String, Object>> resultData) {
        if (ObjectUtils.isEmpty(resultData)) {
            return new ArrayList<>();
        }
        List<Map<String, Object>> resultList = new ArrayList<>();

        resultData.forEach(item -> {
            Map<String, Object> newData = new HashMap<>();

            item.forEach((key, value) -> {
                String[] splitJoint = key.split("121");
                String dbColumnKey = key.contains("121")? splitJoint[0]:ModelAttributeEnum.getAttributeAsKey(key);
                ModelDataTypeEnum dataModelType = ModelDataTypeEnum.getDataModelTypeByName(dbColumnKey);
                if(ObjectUtils.isNotEmpty(dataModelType)){
                    String columnAs = splitJoint.length > 1? splitJoint[1]: dataModelType.getEnName();
                    Object convertedValue = null;
                    AttributeTypeEnums dataType = dataModelType.getDataType();
                    switch (dataType) {
                        case Float, Decimal, Double ->
                                convertedValue = handleInt(value, Integer.parseInt(dataModelType.getFormat()));
                        case Time, DateTime, Year, Date ->
                                convertedValue = handleDate(value, Integer.parseInt(dataModelType.getPattern()));
                        case Object -> convertedValue = handleObject(value);
                        case List -> convertedValue = handleList(value);
                        case Boolean -> convertedValue = handleBoolean(value);
                        case Binary -> convertedValue = handleBinary(value);
                        case Address, Image, Video, Audio, File, Geometry -> convertedValue = handleNeedJson(value);
                        default -> convertedValue = handleDefault(value, dataType);
                    }

                    newData.put(columnAs, convertedValue);
                }else{
                    newData.put(key,handleDefault(value, null));
                }
            });
            resultList.add(newData);
        });
        return resultList;
    }

    /**
     * 转换时间
     * @param value
     * @param dateFormatValue
     * @return
     */
    private Object handleDate( Object value, Integer dateFormatValue) {
        if(dateFormatValue==null) dateFormatValue=4;
        Object transferDate = null;
        try {
            if (value instanceof Date) {
                SimpleDateFormat sdf = new SimpleDateFormat(dateForamtMap.get(dateFormatValue));
                transferDate  = sdf.format(value);
            } else if (value instanceof Temporal) {
                // 日期处理
                transferDate = DateTimeFormatter.ofPattern(dateForamtMap.get(dateFormatValue)).format((Temporal) value);
            }else{
                logger.error("日期转换错误,value:{}", value);
            }

        } catch (Exception e) {
            logger.error("日期转换错误",e);
            return value;
        }
        return transferDate;
    }

    /**
     * object类型处理
     * @param value
     * @return
     */
    private Object handleObject( Object value) {
        if(ObjectUtils.isNotEmpty(value)){
            JSONObject jsonValue = JSONObject.parseObject(value.toString());
            Map<String, Object> innerMap = jsonValue.getInnerMap();
            return innerMap;
        }
        return value;
    }

    /**
     * list类型处理
     * @param value
     * @return
     */
    private Object handleList( Object value) {
        if(ObjectUtils.isNotEmpty(value)) {
            JSONArray jsonArray = JSONArray.parseArray(value.toString());
            JSONArray newJsonArray = new JSONArray();
            for (Object itemJson : jsonArray) {
                if (itemJson instanceof JSONObject) {
                    JSONObject jsonValue = JSONObject.parseObject(itemJson.toString());
                    newJsonArray.add(jsonValue);
                } else {
                    newJsonArray.add(value);
                }
            }
            return newJsonArray;
        }
        return value;
    }

    /**
     * json类型处理
     * @param value
     * @return
     */
    Object handleNeedJson(Object value){
        logger.info("待解析的json数组:{}", value);
        Object converted = null;
        if (value instanceof JSONArray arrayValue) {
            converted =arrayValue;
        } else if (value instanceof JSONObject jsonObjectValue) {
            converted =jsonObjectValue;
        } else if (value instanceof List list) {
            converted=list;
        } else {
            try {
                converted = JSONArray.parseArray(String.valueOf(value));
            } catch (Exception e1) {
                logger.info("待解析的json不为数组:{}", value);
                try {
                    converted  =JSONObject.parseObject(String.valueOf(value));
                } catch (Exception e) {
                    logger.error("待解析的json不为json:{}", value, e);
                    return value;
                }
            }
        }
        return converted;
    }

    /**
     * 默认处理
     * @param value
     * @param dataType
     * @return
     */
    Object handleDefault(Object value, AttributeTypeEnums dataType){
        // logger.info("默认处理数据类型:{}, 值：{}", dataType.getType(), value);
        return value;
    }

    /**
     * 布尔类型处理
     * @param value
     * @return
     */
    Object handleBoolean(Object value){
        return BooleanUtils.toBoolean(String.valueOf(value));
    }

    /**
     * 二进制处理
     * @param value
     * @return
     */
    Object handleBinary(Object value){
        if (value instanceof byte[] byteVal) {
            return Base64.getEncoder().encodeToString(byteVal);
        }
        return value;
    }

    /**
     * 数字类型处理
     * @param value
     * @param scale
     * @return
     */
    Object handleInt(Object value,int scale) {
        // 取保留小数
        return  new BigDecimal(String.valueOf(value))
                .setScale(scale, RoundingMode.CEILING);
    }


}

