package com.wlos.app.da.service;


import com.wlos.app.model.BaseRegion;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.wlos.app.bo.BaseRegionBO; 
import com.wlos.app.vo.BaseRegionVO; 
import java.util.*;
import com.baomidou.mybatisplus.extension.service.IService;


import com.wlos.app.bo.where.DataQuery_YQXFWhereBO;
import com.wlos.app.bo.where.DataQuery_EUQOWhereBO;
import com.wlos.app.bo.where.DataQuery_gdkBWhereBO;/**
 * 地区表 服务接口
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:27 PM
 * @since v0.1
 */
public interface BaseRegionService extends IService<BaseRegion> {

    /**
     * 根据id查询地区表
     *
     * @param id 主键id
     * @return 单条数据
     */
    BaseRegion queryById(String id);
    
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    Page<BaseRegion> page(Page<BaseRegion> page, BaseRegion condition);


    /**
     * 创建地区表
     *
     * @param baseRegion 地区表载体
     * @return 地区表 新增实体主键
     */
    String insert(BaseRegion baseRegion);
    

    /**
     * 更新地区表
     *
     * @param id 主键id
     * @param baseRegion 实例对象
     * @return 影响行数
     */
    Integer update(String id, BaseRegion baseRegion);


    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    Integer deleteById(String id);
    

    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    int deleteByIds(List<String> list);


    
    /**
     * 通用新增
     * 
     * @param baseRegionBo 新增参数 
     * @return 新增id
     */
    String insert(BaseRegionBO baseRegionBo);



    
    /**
     * 流程-根据上级编码和级别编号查询市级列表-数据查询
     * 
     * @param dataQuery_YQXFWhereBo 查询参数BO 
     * @return 查询结果集
     */
    List<BaseRegion> list(DataQuery_YQXFWhereBO dataQuery_YQXFWhereBo);


    
    /**
     * 流程-查询省级列表-数据查询
     * 
     * @param dataQuery_EUQOWhereBo 查询参数BO 
     * @return 查询结果集
     */
    List<BaseRegion> list(DataQuery_EUQOWhereBO dataQuery_EUQOWhereBo);


    
    /**
     * 流程-根据id获取区域信息-数据查询-区域
     * 
     * @param dataQuery_gdkBWhereBo 查询参数BO 
     * @return 查询结果集
     */
    BaseRegion selectOne(DataQuery_gdkBWhereBO dataQuery_gdkBWhereBo);

}