package com.wlos.app.da.service;


import com.wlos.app.model.BaseOpenIssue;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.wlos.app.bo.BaseOpenIssueBO; 
import com.wlos.app.vo.BaseOpenIssueVO; 
import java.util.*;
import com.baomidou.mybatisplus.extension.service.IService;


import com.wlos.app.bo.where.DataQuery_vikAWhereBO;
import com.wlos.app.bo.where.DataQuery_hYiGWhereBO;/**
 * 开放问题表 服务接口
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:26 PM
 * @since v0.1
 */
public interface BaseOpenIssueService extends IService<BaseOpenIssue> {

    /**
     * 根据id查询开放问题表
     *
     * @param id 主键id
     * @return 单条数据
     */
    BaseOpenIssue queryById(String id);
    
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    Page<BaseOpenIssue> page(Page<BaseOpenIssue> page, BaseOpenIssue condition);


    /**
     * 创建开放问题表
     *
     * @param baseOpenIssue 开放问题表载体
     * @return 开放问题表 新增实体主键
     */
    String insert(BaseOpenIssue baseOpenIssue);
    

    /**
     * 更新开放问题表
     *
     * @param id 主键id
     * @param baseOpenIssue 实例对象
     * @return 影响行数
     */
    Integer update(String id, BaseOpenIssue baseOpenIssue);


    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    Integer deleteById(String id);
    

    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    int deleteByIds(List<String> list);


    
    /**
     * 通用新增
     * 
     * @param baseOpenIssueBo 新增参数 
     * @return 新增id
     */
    String insert(BaseOpenIssueBO baseOpenIssueBo);



    
    /**
     * 流程-暂存固定和开放问题-数据查询开发
     * 
     * @param dataQuery_vikAWhereBo 查询参数BO 
     * @return 查询结果集
     */
    List<BaseOpenIssue> list(DataQuery_vikAWhereBO dataQuery_vikAWhereBo);


    
    /**
     * 流程-根据层级和名称查询开放问题列表-数据查询
     * 
     * @param dataQuery_hYiGWhereBo 查询参数BO 
     * @return 查询结果集
     */
    List<BaseOpenIssue> list(DataQuery_hYiGWhereBO dataQuery_hYiGWhereBo);

}