package com.wlos.app.da.service;


import com.wlos.app.model.BaseDict;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.wlos.app.bo.BaseDictBO; 
import com.wlos.app.vo.BaseDictVO; 
import java.util.*;
import com.baomidou.mybatisplus.extension.service.IService;


import com.wlos.app.bo.where.DataQuery_nTODWhereBO;
import com.wlos.app.bo.where.DataQuery_AbzcWhereBO;/**
 * 编码表 服务接口
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:24 PM
 * @since v0.1
 */
public interface BaseDictService extends IService<BaseDict> {

    /**
     * 根据id查询编码表
     *
     * @param id 主键id
     * @return 单条数据
     */
    BaseDict queryById(String id);
    
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    Page<BaseDict> page(Page<BaseDict> page, BaseDict condition);


    /**
     * 创建编码表
     *
     * @param baseDict 编码表载体
     * @return 编码表 新增实体主键
     */
    String insert(BaseDict baseDict);
    

    /**
     * 更新编码表
     *
     * @param id 主键id
     * @param baseDict 实例对象
     * @return 影响行数
     */
    Integer update(String id, BaseDict baseDict);


    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    Integer deleteById(String id);
    

    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    int deleteByIds(List<String> list);


    
    /**
     * 通用新增
     * 
     * @param baseDictBo 新增参数 
     * @return 新增id
     */
    String insert(BaseDictBO baseDictBo);



    
    /**
     * 流程-查询编码列表-数据查询
     * 
     * @param dataQuery_nTODWhereBo 查询参数BO 
     * @return 查询结果集
     */
    List<BaseDict> list(DataQuery_nTODWhereBO dataQuery_nTODWhereBo);


    
    /**
     * 流程-根据类型和编码值查询字典名称-数据查询
     * 
     * @param dataQuery_AbzcWhereBo 查询参数BO 
     * @return 查询结果集
     */
    BaseDict selectOne(DataQuery_AbzcWhereBO dataQuery_AbzcWhereBo);

}