package com.wlos.app.da.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.wlos.app.model.SurveyTask;
import java.util.*;
import org.apache.ibatis.annotations.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.stereotype.Repository;    
import com.wlos.app.bo.SurveyTaskBO; 
import com.wlos.app.vo.SurveyTaskVO; 


import com.wlos.app.bo.where.ModifytskstsdataModificationWhereBO;
import com.wlos.app.bo.where.DataQuery_dykBWhereBO;
import com.wlos.app.bo.where.DataQuery_EQShWhereBO;
import com.wlos.app.bo.where.DataQueryWhereBO;
import com.wlos.app.bo.DataQueryBO;
import com.wlos.app.bo.where.DataQuery_JvFIWhereBO;
import com.wlos.app.bo.DataqueryJvfiBO;

/**
 * 任务信息 表数据库访问层
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:34 PM
 * @since v0.1
 */
@Mapper
@Repository
public interface SurveyTaskMapper extends BaseMapper<SurveyTask> {
 
   /**
    * 修改任务状态-数据修改
    * @param surveyTaskBo 修改参数BO 
    * @param modifytskstsdataModificationWhereBo 修改参数BO 
    * @return 受影响行数
    */
    Integer modifytskstsdataModification(@Param("update")SurveyTaskBO surveyTaskBo,@Param("where")ModifytskstsdataModificationWhereBO modifytskstsdataModificationWhereBo);

  

      
   /**
    * 流程-查询任务详情-数据查询
    * @param dataQuery_dykBWhereBo 查询参数BO 
    * @return 查询结果集
    */
    SurveyTask dataQuery_dykB(@Param("where") DataQuery_dykBWhereBO dataQuery_dykBWhereBo);



      
   /**
    * 流程-根据用户id查询进行中的任务列-数据查询
    * @param dataQuery_EQShWhereBo 查询参数BO 
    * @return 查询结果集
    */
    List<SurveyTask> dataQuery_EQSh(@Param("where") DataQuery_EQShWhereBO dataQuery_EQShWhereBo);



      
   /**
    * 流程-模糊搜索任务-数据查询
    * @param dataQueryWhereBo 查询参数BO 
    * @return 查询结果集
    */
    Page<DataQueryBO> dataQuery(Page<DataQueryBO> page,@Param("where") DataQueryWhereBO dataQueryWhereBo);



      
   /**
    * 流程-不含未接受的任务列表-数据查询
    * @param dataQuery_JvFIWhereBo 查询参数BO 
    * @return 查询结果集
    */
    Page<DataqueryJvfiBO> dataQuery_JvFI(Page<DataqueryJvfiBO> page,@Param("where") DataQuery_JvFIWhereBO dataQuery_JvFIWhereBo);




}