package com.wlos.app.da.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.wlos.app.model.SurveyQuestionnaire;
import java.util.*;
import org.apache.ibatis.annotations.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.stereotype.Repository;    
import com.wlos.app.bo.SurveyQuestionnaireBO; 
import com.wlos.app.vo.SurveyQuestionnaireVO; 


import com.wlos.app.bo.where.ModifyplandataModificationQuestionnaireWhereBO;
import com.wlos.app.bo.where.GenquestionnairedataModificationQuestionnaireStsWhereBO;
import com.wlos.app.bo.where.DataQuery_dqCrWhereBO;
import com.wlos.app.bo.where.DataQuery_iKAYWhereBO;
import com.wlos.app.bo.where.DataQuery_yeFLWhereBO;
import com.wlos.app.bo.where.UpdsurveyresultsreportgenerationundevelopeddataModificationQuestionnaireStsUpdWhereBO;

/**
 * 问卷 表数据库访问层
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:27 PM
 * @since v0.1
 */
@Mapper
@Repository
public interface SurveyQuestionnaireMapper extends BaseMapper<SurveyQuestionnaire> {
 
   /**
    * 修改计划-数据修改-问卷
    * @param surveyQuestionnaireBo 修改参数BO 
    * @param modifyplandataModificationQuestionnaireWhereBo 修改参数BO 
    * @return 受影响行数
    */
    Integer modifyplandataModificationQuestionnaire(@Param("update")SurveyQuestionnaireBO surveyQuestionnaireBo,@Param("where")ModifyplandataModificationQuestionnaireWhereBO modifyplandataModificationQuestionnaireWhereBo);

  

 
   /**
    * 生成问卷-数据修改-问卷状态
    * @param surveyQuestionnaireBo 修改参数BO 
    * @param genquestionnairedataModificationQuestionnaireStsWhereBo 修改参数BO 
    * @return 受影响行数
    */
    Integer genquestionnairedataModificationQuestionnaireSts(@Param("update")SurveyQuestionnaireBO surveyQuestionnaireBo,@Param("where")GenquestionnairedataModificationQuestionnaireStsWhereBO genquestionnairedataModificationQuestionnaireStsWhereBo);

  

      
   /**
    * 流程-生成问卷-数据查询-问卷信息
    * @param dataQuery_dqCrWhereBo 查询参数BO 
    * @return 查询结果集
    */
    SurveyQuestionnaire dataQuery_dqCr(@Param("where") DataQuery_dqCrWhereBO dataQuery_dqCrWhereBo);



      
   /**
    * 流程-根据计划id和问题类型查询问题列表-数据查询-问卷
    * @param dataQuery_iKAYWhereBo 查询参数BO 
    * @return 查询结果集
    */
    SurveyQuestionnaire dataQuery_iKAY(@Param("where") DataQuery_iKAYWhereBO dataQuery_iKAYWhereBo);



      
   /**
    * 流程-新增问卷补充问题记录-数据查询-获取问卷信息
    * @param dataQuery_yeFLWhereBo 查询参数BO 
    * @return 查询结果集
    */
    SurveyQuestionnaire dataQuery_yeFL(@Param("where") DataQuery_yeFLWhereBO dataQuery_yeFLWhereBo);



 
   /**
    * 更新踏勘结果-报告生成未开发-数据修改-问卷状态更新
    * @param surveyQuestionnaireBo 修改参数BO 
    * @param updsurveyresultsreportgenerationundevelopeddataModificationQuestionnaireStsUpdWhereBo 修改参数BO 
    * @return 受影响行数
    */
    Integer updsurveyresultsreportgenerationundevelopeddataModificationQuestionnaireStsUpd(@Param("update")SurveyQuestionnaireBO surveyQuestionnaireBo,@Param("where")UpdsurveyresultsreportgenerationundevelopeddataModificationQuestionnaireStsUpdWhereBO updsurveyresultsreportgenerationundevelopeddataModificationQuestionnaireStsUpdWhereBo);

  


}