package com.wlos.app.da.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.wlos.app.model.SurveyInfo;
import java.util.*;
import org.apache.ibatis.annotations.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.stereotype.Repository;    
import com.wlos.app.bo.SurveyInfoBO; 
import com.wlos.app.vo.SurveyInfoVO; 


import com.wlos.app.bo.where.UpdquestionanswerinformationdataModificationWhereBO;
import com.wlos.app.bo.DataqueryOouxBO;
import com.wlos.app.bo.where.DelcorrespondingrecordsbasedonquestionnairequestioniddelRecordOfQuestionAnswerTblWhereBO;
import com.wlos.app.bo.where.DataQuery_kBPxWhereBO;
import com.wlos.app.bo.DataqueryKbpxBO;
import com.wlos.app.bo.where.DataQuery_VLaLWhereBO;
import com.wlos.app.bo.DataqueryVlalBO;
import com.wlos.app.bo.where.DataQuery_rLQSWhereBO;
import com.wlos.app.bo.where.DataQuery_gXAHWhereBO;
import com.wlos.app.bo.DataqueryGxahBO;
import com.wlos.app.bo.where.DataQuery_YsjPWhereBO;
import com.wlos.app.bo.DataqueryYsjpBO;

/**
 * 查勘现场具体问题及反馈详情 表数据库访问层
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:26 PM
 * @since v0.1
 */
@Mapper
@Repository
public interface SurveyInfoMapper extends BaseMapper<SurveyInfo> {
 
   /**
    * 更新问题回答信息-数据修改
    * @param surveyInfoBo 修改参数BO 
    * @param updquestionanswerinformationdataModificationWhereBo 修改参数BO 
    * @return 受影响行数
    */
    Integer updquestionanswerinformationdataModification(@Param("update")SurveyInfoBO surveyInfoBo,@Param("where")UpdquestionanswerinformationdataModificationWhereBO updquestionanswerinformationdataModificationWhereBo);

  

      
   /**
    * 流程-根据问卷id查询所有问题列表-数据查询
    * @return 查询结果集
    */
    List<DataqueryOouxBO> dataQuery_OouX();



 
   /**
    * 根据问卷问题id删除对应记录-问题回答表记录删除
    * @return 受影响行数
    */
    Integer delcorrespondingrecordsbasedonquestionnairequestioniddelRecordOfQuestionAnswerTbl(DelcorrespondingrecordsbasedonquestionnairequestioniddelRecordOfQuestionAnswerTblWhereBO delcorrespondingrecordsbasedonquestionnairequestioniddelRecordOfQuestionAnswerTblWhereBo);

     

      
   /**
    * 流程-根据回答id查询问题信息-数据查询-问题详情
    * @param dataQuery_kBPxWhereBo 查询参数BO 
    * @return 查询结果集
    */
    DataqueryKbpxBO dataQuery_kBPx(@Param("where") DataQuery_kBPxWhereBO dataQuery_kBPxWhereBo);



      
   /**
    * 流程-下一题-数据查询-查之后的题目
    * @param dataQuery_VLaLWhereBo 查询参数BO 
    * @return 查询结果集
    */
    List<DataqueryVlalBO> dataQuery_VLaL(@Param("where") DataQuery_VLaLWhereBO dataQuery_VLaLWhereBo);



      
   /**
    * 流程-生成问卷-问卷的问题列表
    * @param dataQuery_rLQSWhereBo 查询参数BO 
    * @return 查询结果集
    */
    List<SurveyInfo> dataQuery_rLQS(@Param("where") DataQuery_rLQSWhereBO dataQuery_rLQSWhereBo);



      
   /**
    * 流程-根据计划id和问题类型查询问题列表-数据查询-问题
    * @param dataQuery_gXAHWhereBo 查询参数BO 
    * @return 查询结果集
    */
    List<DataqueryGxahBO> dataQuery_gXAH(@Param("where") DataQuery_gXAHWhereBO dataQuery_gXAHWhereBo);



      
   /**
    * 流程-根据计划id和问题类型查询问题列表-数据查询-已答问题
    * @param dataQuery_YsjPWhereBo 查询参数BO 
    * @return 查询结果集
    */
    List<DataqueryYsjpBO> dataQuery_YsjP(@Param("where") DataQuery_YsjPWhereBO dataQuery_YsjPWhereBo);




}